/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockDefinitionBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ProcessDefinitionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_DEFINITION_QUERY_URL = "/rest-test/process-definition";
    protected static final String PROCESS_DEFINITION_COUNT_QUERY_URL = "/rest-test/process-definition/count";
    private ProcessDefinitionQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockDefinitionQuery(MockProvider.createMockDefinitions());
    }

    private ProcessDefinitionQuery setUpMockDefinitionQuery(List<ProcessDefinition> mockedDefinitions) {
        ProcessDefinitionQuery sampleDefinitionsQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)sampleDefinitionsQuery.list()).thenReturn(mockedDefinitions);
        Mockito.when((Object)sampleDefinitionsQuery.count()).thenReturn((Object)mockedDefinitions.size());
        Mockito.when((Object)processEngine.getRepositoryService().createProcessDefinitionQuery()).thenReturn((Object)sampleDefinitionsQuery);
        return sampleDefinitionsQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("keyLike", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidNumericParameter() {
        String anInvalidIntegerQueryParam = "aString";
        RestAssured.given().queryParam("version", new Object[]{anInvalidIntegerQueryParam}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'version' to value 'aString': Cannot convert value aString to java type java.lang.Integer"), new Object[0]).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidBooleanParameter() {
        String anInvalidBooleanQueryParam = "neitherTrueNorFalse";
        RestAssured.given().queryParam("active", new Object[]{anInvalidBooleanQueryParam}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'active' to value 'neitherTrueNorFalse': Cannot convert value neitherTrueNorFalse to java type java.lang.Boolean"), new Object[0]).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifyFailingSorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST, InvalidRequestException.class.getSimpleName(), "Cannot set query parameter 'sortBy' to value 'anInvalidSortByOption'");
        this.executeAndVerifyFailingSorting("category", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST, InvalidRequestException.class.getSimpleName(), "Cannot set query parameter 'sortOrder' to value 'anInvalidSortOrderOption'");
    }

    protected void executeAndVerifySuccessfulSorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    protected void executeAndVerifyFailingSorting(String sortBy, String sortOrder, Response.Status expectedStatus, String expectedErrorType, String expectedErrorMessage) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)expectedErrorType), new Object[0]).body("message", Matchers.equalTo((Object)expectedErrorMessage), new Object[0]).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"category"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testProcessDefinitionRetrieval() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        String queryKey = "Key";
        Response response = (Response)RestAssured.given().queryParam("keyLike", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).processDefinitionKeyLike(queryKey);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process definition returned.", (long)1L, (long)definitions.size());
        Assert.assertNotNull((String)"There should be one process definition returned", definitions.get(0));
        String returnedDefinitionKey = JsonPath.from((String)content).getString("[0].key");
        String returnedDefinitionId = JsonPath.from((String)content).getString("[0].id");
        String returnedCategory = JsonPath.from((String)content).getString("[0].category");
        String returnedDefinitionName = JsonPath.from((String)content).getString("[0].name");
        String returnedDescription = JsonPath.from((String)content).getString("[0].description");
        int returnedVersion = JsonPath.from((String)content).getInt("[0].version");
        String returnedResourceName = JsonPath.from((String)content).getString("[0].resource");
        String returnedDeploymentId = JsonPath.from((String)content).getString("[0].deploymentId");
        String returnedDiagramResourceName = JsonPath.from((String)content).getString("[0].diagram");
        Boolean returnedIsSuspended = JsonPath.from((String)content).getBoolean("[0].suspended");
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedDefinitionKey);
        Assert.assertEquals((Object)"aCategory", (Object)returnedCategory);
        Assert.assertEquals((Object)"aName", (Object)returnedDefinitionName);
        Assert.assertEquals((Object)"aDescription", (Object)returnedDescription);
        Assert.assertEquals((long)42L, (long)returnedVersion);
        Assert.assertEquals((Object)"aResourceName", (Object)returnedResourceName);
        Assert.assertEquals((Object)"aDeploymentId", (Object)returnedDeploymentId);
        Assert.assertEquals((Object)"aResourceName.png", (Object)returnedDiagramResourceName);
        Assert.assertEquals((Object)true, (Object)returnedIsSuspended);
    }

    @Test
    public void testProcessDefinitionRetrievalByList() {
        this.mockedQuery = this.setUpMockDefinitionQuery(MockProvider.createMockTwoDefinitions());
        Response response = (Response)RestAssured.given().queryParam("processDefinitionIdIn", new Object[]{"aProcDefId,aProcessDefinitionId:2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).processDefinitionIdIn(new String[]{"aProcDefId", "aProcessDefinitionId:2"});
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedDefinitionId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedDefinitionId2 = JsonPath.from((String)content).getString("[1].id");
        Assertions.assertThat((String)returnedDefinitionId1).isEqualTo((Object)"aProcDefId");
        Assertions.assertThat((String)returnedDefinitionId2).isEqualTo((Object)"aProcessDefinitionId:2");
    }

    @Test
    public void testProcessDefinitionRetrievalByEmptyList() {
        this.mockedQuery = this.setUpMockDefinitionQuery(MockProvider.createMockTwoDefinitions());
        Response response = (Response)RestAssured.given().queryParam("processDefinitionIdIn", new Object[]{""}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).processDefinitionIdIn((String[])org.mockito.Matchers.anyVararg());
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedDefinitionId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedDefinitionId2 = JsonPath.from((String)content).getString("[1].id");
        Assertions.assertThat((String)returnedDefinitionId1).isEqualTo((Object)"aProcDefId");
        Assertions.assertThat((String)returnedDefinitionId2).isEqualTo((Object)"aProcessDefinitionId:2");
    }

    @Test
    public void testIncompleteProcessDefinition() {
        this.setUpMockDefinitionQuery(this.createIncompleteMockDefinitions());
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        String content = response.asString();
        String returnedResourceName = JsonPath.from((String)content).getString("[0].resource");
        Assert.assertNull((String)"Should be null, as it is also null in the original process definition on the server.", (Object)returnedResourceName);
    }

    private List<ProcessDefinition> createIncompleteMockDefinitions() {
        ArrayList<ProcessDefinition> mocks = new ArrayList<ProcessDefinition>();
        MockDefinitionBuilder builder = new MockDefinitionBuilder();
        ProcessDefinition mockDefinition = builder.id("aProcDefId").category("aCategory").name("aName").key("aKey").suspended(true).version(42).build();
        mocks.add(mockDefinition);
        return mocks;
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(queryParameters.get("processDefinitionId"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionCategory(queryParameters.get("category"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionCategoryLike(queryParameters.get("categoryLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionName(queryParameters.get("name"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionNameLike(queryParameters.get("nameLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("deploymentId"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(queryParameters.get("key"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyLike(queryParameters.get("keyLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionVersion(Integer.valueOf(Integer.parseInt(queryParameters.get("version"))));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).latestVersion();
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionResourceName(queryParameters.get("resourceName"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionResourceNameLike(queryParameters.get("resourceNameLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).startableByUser(queryParameters.get("startableBy"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(queryParameters.get("incidentId"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(queryParameters.get("incidentType"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(queryParameters.get("incidentMessage"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessageLike(queryParameters.get("incidentMessageLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTag(queryParameters.get("versionTag"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTagLike(queryParameters.get("versionTagLike"));
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", "anId");
        parameters.put("category", "cat");
        parameters.put("categoryLike", "catlike");
        parameters.put("name", "name");
        parameters.put("nameLike", "namelike");
        parameters.put("deploymentId", "depId");
        parameters.put("key", "key");
        parameters.put("keyLike", "keylike");
        parameters.put("version", "0");
        parameters.put("latestVersion", "true");
        parameters.put("resourceName", "res");
        parameters.put("resourceNameLike", "resLike");
        parameters.put("startableBy", "kermit");
        parameters.put("suspended", "true");
        parameters.put("active", "true");
        parameters.put("incidentId", "incId");
        parameters.put("incidentType", "incType");
        parameters.put("incidentMessage", "incMessage");
        parameters.put("incidentMessageLike", "incMessageLike");
        parameters.put("versionTag", "semVer");
        parameters.put("versionTagLike", "semVerLike");
        return parameters;
    }

    @Test
    public void testProcessDefinitionTenantIdList() {
        List<ProcessDefinition> processDefinitions = Arrays.asList(MockProvider.mockDefinition().tenantId("aTenantId").build(), MockProvider.mockDefinition().id("aProcessDefinitionId:2").tenantId("anotherTenantId").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(processDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testProcessDefinitionKeysList() {
        List<ProcessDefinition> processDefinitions = Arrays.asList(MockProvider.mockDefinition().key("aKey").build(), MockProvider.mockDefinition().key("anotherProcessDefinitionKey").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(processDefinitions);
        Response response = (Response)RestAssured.given().queryParam("keysIn", new Object[]{"aKey,anotherProcessDefinitionKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeysIn(new String[]{"aKey", "anotherProcessDefinitionKey"});
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedKey1 = JsonPath.from((String)content).getString("[0].key");
        String returnedKey2 = JsonPath.from((String)content).getString("[1].key");
        Assertions.assertThat((String)returnedKey1).isEqualTo((Object)"aKey");
        Assertions.assertThat((String)returnedKey2).isEqualTo((Object)"anotherProcessDefinitionKey");
    }

    @Test
    public void testProcessDefinitionWithoutTenantId() {
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testProcessDefinitionTenantIdIncludeDefinitionsWithoutTenantid() {
        List<ProcessDefinition> processDefinitions = Arrays.asList(MockProvider.mockDefinition().tenantId(null).build(), MockProvider.mockDefinition().tenantId("aTenantId").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(processDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeProcessDefinitionsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).includeProcessDefinitionsWithoutTenantId();
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    @Test
    public void testProcessDefinitionVersionTag() {
        List<ProcessDefinition> processDefinitions = Arrays.asList(MockProvider.mockDefinition().versionTag("aVersionTag").build(), MockProvider.mockDefinition().id("aProcessDefinitionId:2").versionTag("anotherVersionTag").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(processDefinitions);
        Response response = (Response)RestAssured.given().queryParam("versionTag", new Object[]{"aVersionTag"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTag("aVersionTag");
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("category", "asc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionCategory();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("key", "desc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("id", "asc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("version", "desc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionVersion();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("name", "asc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionName();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("deploymentId", "desc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("tenantId", "asc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("tenantId", "desc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("versionTag", "asc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByVersionTag();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("versionTag", "desc", Response.Status.OK);
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByVersionTag();
        ((ProcessDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(PROCESS_DEFINITION_COUNT_QUERY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }
}

