/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.ModificationInstructionBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class RestartProcessInstanceRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_DEFINITION_URL = "/rest-test/process-definition";
    protected static final String SINGLE_PROCESS_DEFINITION_URL = "/rest-test/process-definition/{id}";
    protected static final String RESTART_PROCESS_INSTANCE_URL = "/rest-test/process-definition/{id}/restart";
    protected static final String RESTART_PROCESS_INSTANCE_ASYNC_URL = "/rest-test/process-definition/{id}/restart-async";
    RuntimeService runtimeServiceMock;
    HistoryService historyServiceMock;
    RestartProcessInstanceBuilder builderMock;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.builderMock = (RestartProcessInstanceBuilder)Mockito.mock(RestartProcessInstanceBuilder.class);
        Mockito.when((Object)this.builderMock.startAfterActivity(org.mockito.Matchers.anyString())).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.startBeforeActivity(org.mockito.Matchers.anyString())).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.startTransition(org.mockito.Matchers.anyString())).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.processInstanceIds(org.mockito.Matchers.anyListOf(String.class))).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.historicProcessInstanceQuery((HistoricProcessInstanceQuery)Mockito.any(HistoricProcessInstanceQuery.class))).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.skipCustomListeners()).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.skipIoMappings()).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.initialSetOfVariables()).thenReturn((Object)this.builderMock);
        Mockito.when((Object)this.builderMock.withoutBusinessKey()).thenReturn((Object)this.builderMock);
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.builderMock.executeAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.restartProcessInstances(org.mockito.Matchers.anyString())).thenReturn((Object)this.builderMock);
    }

    @Test
    public void testRestartProcessInstanceSync() {
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("processInstanceIds", Arrays.asList("processInstanceId1", "processInstanceId2"));
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).restartProcessInstances("aProcDefId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startAfterActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstanceId1", "processInstanceId2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceAsync() {
        HashMap<String, List<Object>> json = new HashMap<String, List<Object>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("processInstanceIds", Arrays.asList("processInstanceId1", "processInstanceId2"));
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).restartProcessInstances("aProcDefId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startAfterActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstanceId1", "processInstanceId2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
    }

    @Test
    public void testRestartProcessInstanceWithNullProcessInstanceIdsSync() {
        ((RestartProcessInstanceBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("processInstanceIds is null")).when((Object)this.builderMock)).execute();
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithNullProcessInstanceIdsAsync() {
        ((RestartProcessInstanceBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("processInstanceIds is null")).when((Object)this.builderMock)).executeAsync();
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithHistoricProcessInstanceQuerySync() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setProcessInstanceBusinessKey("businessKey");
        json.put("historicProcessInstanceQuery", query);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).restartProcessInstances("aProcDefId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)query.toQuery(processEngine));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceWithHistoricProcessInstanceQueryAsync() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setProcessInstanceBusinessKey("businessKey");
        json.put("historicProcessInstanceQuery", query);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).restartProcessInstances("aProcDefId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)query.toQuery(processEngine));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
    }

    @Test
    public void testRestartProcessInstanceWithNullInstructionsSync() {
        ((RestartProcessInstanceBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("instructions is null")).when((Object)this.builderMock)).execute();
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processInstanceIds", "processInstanceId");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithNullInstructionsAsync() {
        ((RestartProcessInstanceBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("instructions is null")).when((Object)this.builderMock)).executeAsync();
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processInstanceIds", "processInstanceId");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartAfterSync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startAfterActivity': 'activityId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartAfterAsync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startAfterActivity': 'activityId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartBeforeSync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startBeforeActivity': 'activityId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartBeforeAsync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startBeforeActivity': 'activityId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartTransitionSync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startTransition': 'transitionId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInvalidModificationInstructionForStartTransitionAsync() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startTransition': 'transitionId' must be set"), new Object[0]).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testRestartProcessInstanceWithInitialVariablesAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("initialVariables", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).initialSetOfVariables();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
    }

    @Test
    public void testRestartProcessInstanceWithInitialVariablesSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("initialVariables", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).initialSetOfVariables();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceWithSkipCustomListenersAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("skipCustomListeners", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).skipCustomListeners();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
    }

    @Test
    public void testRestartProcessInstanceWithSkipCustomListenersSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("skipCustomListeners", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).skipCustomListeners();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceWithSkipIoMappingsAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("skipIoMappings", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).skipIoMappings();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
    }

    @Test
    public void testRestartProcessInstanceWithSkipIoMappingsSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("skipIoMappings", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).skipIoMappings();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceWithoutBusinessKey() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("processInstanceIds", Arrays.asList("processInstance1", "processInstance2"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("withoutBusinessKey", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).processInstanceIds(Arrays.asList("processInstance1", "processInstance2"));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).withoutBusinessKey();
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
    }

    @Test
    public void testRestartProcessInstanceWithoutProcessInstanceIdsSync() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setFinished(Boolean.valueOf(true));
        json.put("historicProcessInstanceQuery", query);
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)query.toQuery(processEngine));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builderMock});
    }

    @Test
    public void testRestartProcessInstanceWithoutProcessInstanceIdsAsync() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setFinished(Boolean.valueOf(true));
        json.put("historicProcessInstanceQuery", query);
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RESTART_PROCESS_INSTANCE_ASYNC_URL, new Object[0]);
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).startBeforeActivity("activityId");
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)query.toQuery(processEngine));
        ((RestartProcessInstanceBuilder)Mockito.verify((Object)this.builderMock)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builderMock});
    }
}

