/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.SignalEventReceivedBuilderImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.SignalEventReceivedBuilder;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SignalRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String SIGNAL_URL = "/rest-test/signal";
    private RuntimeService runtimeServiceMock;
    private SignalEventReceivedBuilder signalBuilderMock;

    @Before
    public void setupMocks() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.signalBuilderMock = (SignalEventReceivedBuilder)Mockito.mock(SignalEventReceivedBuilderImpl.class);
        Mockito.when((Object)this.runtimeServiceMock.createSignalEvent(Matchers.anyString())).thenReturn((Object)this.signalBuilderMock);
        Mockito.when((Object)this.signalBuilderMock.setVariables((Map)Matchers.any())).thenReturn((Object)this.signalBuilderMock);
        Mockito.when((Object)this.signalBuilderMock.executionId(Matchers.anyString())).thenReturn((Object)this.signalBuilderMock);
        Mockito.when((Object)this.signalBuilderMock.tenantId(Matchers.anyString())).thenReturn((Object)this.signalBuilderMock);
        Mockito.when((Object)this.signalBuilderMock.withoutTenantId()).thenReturn((Object)this.signalBuilderMock);
    }

    @Test
    public void shouldBroadcast() {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldBroadcastWithVariables() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldBroadcastWithTenant() {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        requestBody.put("tenantId", "aTenantId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).tenantId((String)requestBody.get("tenantId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldBroadcastWithVariablesAndTenant() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        requestBody.put("tenantId", "aTenantId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).tenantId((String)requestBody.get("tenantId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldBroadcastWithoutTenant() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).withoutTenantId();
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldBroadcastWithoutTenantAndWithVariables() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        requestBody.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).withoutTenantId();
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecution() {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        requestBody.put("executionId", "anExecutionId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecutionWithVariables() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("executionId", "anExecutionId");
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecutionWithTenant() {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        requestBody.put("tenantId", "aTenantId");
        requestBody.put("executionId", "anExecutionId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).tenantId((String)requestBody.get("tenantId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecutionWithVariablesAndTenant() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("executionId", "anExecutionId");
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        requestBody.put("tenantId", "aTenantId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).tenantId((String)requestBody.get("tenantId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecutionWithoutTenant() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("executionId", "anExecutionId");
        requestBody.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).withoutTenantId();
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldDeliverToSingleExecutionWithoutTenantAndWithVariables() {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", "aSignalName");
        requestBody.put("executionId", "anExecutionId");
        requestBody.put("withoutTenantId", true);
        requestBody.put("variables", VariablesBuilder.create().variable("total", 420).variable("invoiceId", "ABC123").getVariables());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createSignalEvent((String)requestBody.get("name"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).executionId((String)requestBody.get("executionId"));
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).withoutTenantId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("total", 420);
        expectedVariables.put("invoiceId", "ABC123");
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).setVariables(expectedVariables);
        ((SignalEventReceivedBuilder)Mockito.verify((Object)this.signalBuilderMock)).send();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalBuilderMock});
    }

    @Test
    public void shouldThrowExceptionByMissingName() {
        HashMap requestBody = new HashMap();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", IsEqual.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)"No signal name given"), new Object[0]).when().post(SIGNAL_URL, new Object[0]);
    }

    @Test
    public void shouldThrowBadUserRequestException() {
        String message = "expected exception";
        ((SignalEventReceivedBuilder)Mockito.doThrow((Throwable)new BadUserRequestException(message)).when((Object)this.signalBuilderMock)).send();
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", IsEqual.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)message), new Object[0]).when().post(SIGNAL_URL, new Object[0]);
    }

    @Test
    public void shouldThrowAuthorizationException() {
        String message = "expected exception";
        ((SignalEventReceivedBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.signalBuilderMock)).send();
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", IsEqual.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)message), new Object[0]).when().post(SIGNAL_URL, new Object[0]);
    }

    @Test
    public void shouldThrowProcessEngineException() {
        String message = "expected exception";
        ((SignalEventReceivedBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(message)).when((Object)this.signalBuilderMock)).send();
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", "aSignalName");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", IsEqual.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)message), new Object[0]).when().post(SIGNAL_URL, new Object[0]);
    }
}

