/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReport;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CleanableHistoricBatchReportServiceTest
extends AbstractRestServiceTest {
    private static final String EXAMPLE_TYPE = "batchId1";
    private static final int EXAMPLE_TTL = 5;
    private static final long EXAMPLE_FINISHED_COUNT = 10L;
    private static final long EXAMPLE_CLEANABLE_COUNT = 5L;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history/batch";
    protected static final String HISTORIC_REPORT_URL = "/rest-test/history/batch/cleanable-batch-report";
    protected static final String HISTORIC_REPORT_COUNT_URL = "/rest-test/history/batch/cleanable-batch-report/count";
    private CleanableHistoricBatchReport historicBatchReport;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoryReportMock();
    }

    private void setupHistoryReportMock() {
        CleanableHistoricBatchReport report = (CleanableHistoricBatchReport)Mockito.mock(CleanableHistoricBatchReport.class);
        CleanableHistoricBatchReportResult reportResult = (CleanableHistoricBatchReportResult)Mockito.mock(CleanableHistoricBatchReportResult.class);
        Mockito.when((Object)reportResult.getBatchType()).thenReturn((Object)EXAMPLE_TYPE);
        Mockito.when((Object)reportResult.getHistoryTimeToLive()).thenReturn((Object)5);
        Mockito.when((Object)reportResult.getFinishedBatchesCount()).thenReturn((Object)10L);
        Mockito.when((Object)reportResult.getCleanableBatchesCount()).thenReturn((Object)5L);
        CleanableHistoricBatchReportResult anotherReportResult = (CleanableHistoricBatchReportResult)Mockito.mock(CleanableHistoricBatchReportResult.class);
        Mockito.when((Object)anotherReportResult.getBatchType()).thenReturn((Object)"batchId2");
        Mockito.when((Object)anotherReportResult.getHistoryTimeToLive()).thenReturn(null);
        Mockito.when((Object)anotherReportResult.getFinishedBatchesCount()).thenReturn((Object)13L);
        Mockito.when((Object)anotherReportResult.getCleanableBatchesCount()).thenReturn((Object)0L);
        ArrayList<CleanableHistoricBatchReportResult> mocks = new ArrayList<CleanableHistoricBatchReportResult>();
        mocks.add(reportResult);
        mocks.add(anotherReportResult);
        Mockito.when((Object)report.list()).thenReturn(mocks);
        Mockito.when((Object)report.count()).thenReturn((Object)mocks.size());
        this.historicBatchReport = report;
        Mockito.when((Object)processEngine.getHistoryService().createCleanableHistoricBatchReport()).thenReturn((Object)this.historicBatchReport);
    }

    @Test
    public void testGetReport() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicBatchReport});
        ((CleanableHistoricBatchReport)inOrder.verify((Object)this.historicBatchReport)).list();
    }

    @Test
    public void testReportRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicBatchReport});
        ((CleanableHistoricBatchReport)inOrder.verify((Object)this.historicBatchReport)).list();
        String content = response.asString();
        List reportResults = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two report results returned.", (long)2L, (long)reportResults.size());
        Assert.assertNotNull(reportResults.get(0));
        String returnedBatchType = JsonPath.from((String)content).getString("[0].batchType");
        int returnedTTL = JsonPath.from((String)content).getInt("[0].historyTimeToLive");
        long returnedFinishedCount = JsonPath.from((String)content).getLong("[0].finishedBatchesCount");
        long returnedCleanableCount = JsonPath.from((String)content).getLong("[0].cleanableBatchesCount");
        Assert.assertEquals((Object)EXAMPLE_TYPE, (Object)returnedBatchType);
        Assert.assertEquals((long)5L, (long)returnedTTL);
        Assert.assertEquals((long)10L, (long)returnedFinishedCount);
        Assert.assertEquals((long)5L, (long)returnedCleanableCount);
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.historicBatchReport.list()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        ((CleanableHistoricBatchReport)Mockito.verify((Object)this.historicBatchReport)).count();
    }

    @Test
    public void testOrderByFinishedBatchOperationAsc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricBatchReport)Mockito.verify((Object)this.historicBatchReport)).orderByFinishedBatchOperation();
        ((CleanableHistoricBatchReport)Mockito.verify((Object)this.historicBatchReport)).asc();
    }

    @Test
    public void testOrderByFinishedBatchOperationDesc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"desc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricBatchReport)Mockito.verify((Object)this.historicBatchReport)).orderByFinishedBatchOperation();
        ((CleanableHistoricBatchReport)Mockito.verify((Object)this.historicBatchReport)).desc();
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("finished", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }
}

