/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CleanableHistoricDecisionInstanceReportServiceTest
extends AbstractRestServiceTest {
    private static final String EXAMPLE_DD_ID = "anId";
    private static final String EXAMPLE_DD_KEY = "aKey";
    private static final String EXAMPLE_DD_NAME = "aName";
    private static final int EXAMPLE_DD_VERSION = 42;
    private static final int EXAMPLE_TTL = 5;
    private static final long EXAMPLE_FINISHED_DI_COUNT = 1000L;
    private static final long EXAMPLE_CLEANABLE_DI_COUNT = 567L;
    private static final String EXAMPLE_TENANT_ID = "aTenantId";
    protected static final String ANOTHER_EXAMPLE_DD_ID = "anotherDefId";
    protected static final String ANOTHER_EXAMPLE_DD_KEY = "anotherDefKey";
    protected static final String ANOTHER_EXAMPLE_TENANT_ID = "anotherTenantId";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history/decision-definition";
    protected static final String HISTORIC_REPORT_URL = "/rest-test/history/decision-definition/cleanable-decision-instance-report";
    protected static final String HISTORIC_REPORT_COUNT_URL = "/rest-test/history/decision-definition/cleanable-decision-instance-report/count";
    private CleanableHistoricDecisionInstanceReport historicDecisionInstanceReport;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoryReportMock();
    }

    private void setupHistoryReportMock() {
        CleanableHistoricDecisionInstanceReport report = (CleanableHistoricDecisionInstanceReport)Mockito.mock(CleanableHistoricDecisionInstanceReport.class);
        Mockito.when((Object)report.decisionDefinitionIdIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)report);
        Mockito.when((Object)report.decisionDefinitionKeyIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)report);
        CleanableHistoricDecisionInstanceReportResult reportResult = (CleanableHistoricDecisionInstanceReportResult)Mockito.mock(CleanableHistoricDecisionInstanceReportResult.class);
        Mockito.when((Object)reportResult.getDecisionDefinitionId()).thenReturn((Object)EXAMPLE_DD_ID);
        Mockito.when((Object)reportResult.getDecisionDefinitionKey()).thenReturn((Object)EXAMPLE_DD_KEY);
        Mockito.when((Object)reportResult.getDecisionDefinitionName()).thenReturn((Object)EXAMPLE_DD_NAME);
        Mockito.when((Object)reportResult.getDecisionDefinitionVersion()).thenReturn((Object)42);
        Mockito.when((Object)reportResult.getHistoryTimeToLive()).thenReturn((Object)5);
        Mockito.when((Object)reportResult.getFinishedDecisionInstanceCount()).thenReturn((Object)1000L);
        Mockito.when((Object)reportResult.getCleanableDecisionInstanceCount()).thenReturn((Object)567L);
        Mockito.when((Object)reportResult.getTenantId()).thenReturn((Object)EXAMPLE_TENANT_ID);
        CleanableHistoricDecisionInstanceReportResult anotherReportResult = (CleanableHistoricDecisionInstanceReportResult)Mockito.mock(CleanableHistoricDecisionInstanceReportResult.class);
        Mockito.when((Object)anotherReportResult.getDecisionDefinitionId()).thenReturn((Object)ANOTHER_EXAMPLE_DD_ID);
        Mockito.when((Object)anotherReportResult.getDecisionDefinitionKey()).thenReturn((Object)ANOTHER_EXAMPLE_DD_KEY);
        Mockito.when((Object)anotherReportResult.getDecisionDefinitionName()).thenReturn((Object)"dpName");
        Mockito.when((Object)anotherReportResult.getDecisionDefinitionVersion()).thenReturn((Object)33);
        Mockito.when((Object)anotherReportResult.getHistoryTimeToLive()).thenReturn((Object)5);
        Mockito.when((Object)anotherReportResult.getFinishedDecisionInstanceCount()).thenReturn((Object)10L);
        Mockito.when((Object)anotherReportResult.getCleanableDecisionInstanceCount()).thenReturn((Object)0L);
        Mockito.when((Object)anotherReportResult.getTenantId()).thenReturn((Object)ANOTHER_EXAMPLE_TENANT_ID);
        ArrayList<CleanableHistoricDecisionInstanceReportResult> mocks = new ArrayList<CleanableHistoricDecisionInstanceReportResult>();
        mocks.add(reportResult);
        mocks.add(anotherReportResult);
        Mockito.when((Object)report.list()).thenReturn(mocks);
        Mockito.when((Object)report.count()).thenReturn((Object)mocks.size());
        this.historicDecisionInstanceReport = report;
        Mockito.when((Object)processEngine.getHistoryService().createCleanableHistoricDecisionInstanceReport()).thenReturn((Object)this.historicDecisionInstanceReport);
    }

    @Test
    public void testGetReport() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicDecisionInstanceReport});
        ((CleanableHistoricDecisionInstanceReport)inOrder.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testReportRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicDecisionInstanceReport});
        ((CleanableHistoricDecisionInstanceReport)inOrder.verify((Object)this.historicDecisionInstanceReport)).list();
        String content = response.asString();
        List reportResults = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two report results returned.", (long)2L, (long)reportResults.size());
        Assert.assertNotNull(reportResults.get(0));
        String returnedDefinitionId = JsonPath.from((String)content).getString("[0].decisionDefinitionId");
        String returnedDefinitionKey = JsonPath.from((String)content).getString("[0].decisionDefinitionKey");
        String returnedDefinitionName = JsonPath.from((String)content).getString("[0].decisionDefinitionName");
        int returnedDefinitionVersion = JsonPath.from((String)content).getInt("[0].decisionDefinitionVersion");
        int returnedTTL = JsonPath.from((String)content).getInt("[0].historyTimeToLive");
        long returnedFinishedCount = JsonPath.from((String)content).getLong("[0].finishedDecisionInstanceCount");
        long returnedCleanableCount = JsonPath.from((String)content).getLong("[0].cleanableDecisionInstanceCount");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)EXAMPLE_DD_ID, (Object)returnedDefinitionId);
        Assert.assertEquals((Object)EXAMPLE_DD_KEY, (Object)returnedDefinitionKey);
        Assert.assertEquals((Object)EXAMPLE_DD_NAME, (Object)returnedDefinitionName);
        Assert.assertEquals((long)42L, (long)returnedDefinitionVersion);
        Assert.assertEquals((long)5L, (long)returnedTTL);
        Assert.assertEquals((long)1000L, (long)returnedFinishedCount);
        Assert.assertEquals((long)567L, (long)returnedCleanableCount);
        Assert.assertEquals((Object)EXAMPLE_TENANT_ID, (Object)returnedTenantId);
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.historicDecisionInstanceReport.list()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testQueryByDefinitionId() {
        RestAssured.given().queryParam("decisionDefinitionIdIn", new Object[]{"anId,anotherDefId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).decisionDefinitionIdIn(new String[]{EXAMPLE_DD_ID, ANOTHER_EXAMPLE_DD_ID});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testQueryByDefinitionKey() {
        RestAssured.given().queryParam("decisionDefinitionKeyIn", new Object[]{"aKey,anotherDefKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).decisionDefinitionKeyIn(new String[]{EXAMPLE_DD_KEY, ANOTHER_EXAMPLE_DD_KEY});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testQueryByTenantId() {
        RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testQueryWithoutTenantId() {
        RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).withoutTenantId();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testQueryCompact() {
        RestAssured.given().queryParam("compact", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).compact();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testFullQuery() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).count();
    }

    @Test
    public void testOrderByFinishedDecisionInstanceAsc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).orderByFinished();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).asc();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testOrderByFinishedDecisionInstanceDesc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"desc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).orderByFinished();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).desc();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicDecisionInstanceReport});
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("finished", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("decisionDefinitionIdIn", "anId,anotherDefId");
        parameters.put("decisionDefinitionKeyIn", "aKey,anotherDefKey");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        parameters.put("compact", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).decisionDefinitionIdIn(new String[]{EXAMPLE_DD_ID, ANOTHER_EXAMPLE_DD_ID});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).decisionDefinitionKeyIn(new String[]{EXAMPLE_DD_KEY, ANOTHER_EXAMPLE_DD_KEY});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).withoutTenantId();
        ((CleanableHistoricDecisionInstanceReport)Mockito.verify((Object)this.historicDecisionInstanceReport)).compact();
    }
}

