/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceStatistics;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricDecisionStatisticsRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history";
    protected static final String HISTORIC_DECISION_STATISTICS_URL = "/rest-test/history/decision-requirements-definition/{id}/statistics";
    private HistoricDecisionInstanceStatisticsQuery historicDecisionInstanceStatisticsQuery;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoricDecisionStatisticsMock();
    }

    @After
    public void tearDown() {
        Mockito.reset((Object[])new Object[]{processEngine.getHistoryService(), this.historicDecisionInstanceStatisticsQuery});
    }

    private void setupHistoricDecisionStatisticsMock() {
        List<HistoricDecisionInstanceStatistics> mocks = MockProvider.createMockHistoricDecisionStatistics();
        this.historicDecisionInstanceStatisticsQuery = (HistoricDecisionInstanceStatisticsQuery)Mockito.mock(HistoricDecisionInstanceStatisticsQuery.class);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricDecisionInstanceStatisticsQuery((String)Matchers.eq((Object)"aDecisionRequirementsDefinitionId"))).thenReturn((Object)this.historicDecisionInstanceStatisticsQuery);
        Mockito.when((Object)this.historicDecisionInstanceStatisticsQuery.decisionInstanceId("aDecisionInstanceId")).thenReturn((Object)this.historicDecisionInstanceStatisticsQuery);
        Mockito.when((Object)this.historicDecisionInstanceStatisticsQuery.list()).thenReturn(mocks);
    }

    @Test
    public void testHistoricDefinitionInstanceStatisticsRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aDecisionRequirementsDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.is((Object)2), new Object[0]).body("decisionDefinitionKey", org.hamcrest.Matchers.hasItems((Object[])new String[]{"aDecisionDefinitionKey", "anotherDecisionDefinitionKey"}), new Object[0]).body("evaluations", org.hamcrest.Matchers.hasItems((Object[])new Integer[]{1, 2}), new Object[0]).when().get(HISTORIC_DECISION_STATISTICS_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)processEngine.getHistoryService())).createHistoricDecisionInstanceStatisticsQuery("aDecisionRequirementsDefinitionId");
    }

    @Test
    public void testHistoricDefinitionInstanceStatisticsRetrievalWithDefinitionInstance() {
        RestAssured.given().pathParam("id", (Object)"aDecisionRequirementsDefinitionId").queryParam("decisionInstanceId", new Object[]{"aDecisionInstanceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.is((Object)2), new Object[0]).body("decisionDefinitionKey", org.hamcrest.Matchers.hasItems((Object[])new String[]{"aDecisionDefinitionKey", "anotherDecisionDefinitionKey"}), new Object[0]).body("evaluations", org.hamcrest.Matchers.hasItems((Object[])new Integer[]{1, 2}), new Object[0]).when().get(HISTORIC_DECISION_STATISTICS_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)processEngine.getHistoryService())).createHistoricDecisionInstanceStatisticsQuery("aDecisionRequirementsDefinitionId");
        ((HistoricDecisionInstanceStatisticsQuery)Mockito.verify((Object)this.historicDecisionInstanceStatisticsQuery)).decisionInstanceId("aDecisionInstanceId");
    }
}

