/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.management.SetJobRetriesBuilder;
import org.camunda.bpm.engine.management.UpdateJobDefinitionSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.management.UpdateJobDefinitionSuspensionStateTenantBuilder;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockJobDefinitionBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobDefinitionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String JOB_DEFINITION_RESOURCE_URL = "/rest-test/job-definition";
    protected static final String SINGLE_JOB_DEFINITION_RESOURCE_URL = "/rest-test/job-definition/{id}";
    protected static final String SINGLE_JOB_DEFINITION_SUSPENDED_URL = "/rest-test/job-definition/{id}/suspended";
    protected static final String JOB_DEFINITION_SUSPENDED_URL = "/rest-test/job-definition/suspended";
    protected static final String JOB_DEFINITION_RETRIES_URL = "/rest-test/job-definition/{id}/retries";
    protected static final String JOB_DEFINITION_PRIORITY_URL = "/rest-test/job-definition/{id}/jobPriority";
    private ProcessEngine namedProcessEngine;
    private ManagementService mockManagementService;
    private UpdateJobDefinitionSuspensionStateTenantBuilder mockSuspensionStateBuilder;
    private UpdateJobDefinitionSuspensionStateSelectBuilder mockSuspensionStateSelectBuilder;
    private JobDefinitionQuery mockQuery;
    private SetJobRetriesBuilder mockSetJobRetriesBuilder;

    @Before
    public void setUpRuntimeData() {
        this.mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getManagementService()).thenReturn((Object)this.mockManagementService);
        List<JobDefinition> mockJobDefinitions = Collections.singletonList(MockProvider.createMockJobDefinition());
        this.mockQuery = this.setUpMockJobDefinitionQuery(mockJobDefinitions);
        this.mockSuspensionStateSelectBuilder = (UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.mock(UpdateJobDefinitionSuspensionStateSelectBuilder.class);
        Mockito.when((Object)this.mockManagementService.updateJobDefinitionSuspensionState()).thenReturn((Object)this.mockSuspensionStateSelectBuilder);
        this.mockSuspensionStateBuilder = (UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.mock(UpdateJobDefinitionSuspensionStateTenantBuilder.class);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byJobDefinitionId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionKey(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        this.mockSetJobRetriesBuilder = (SetJobRetriesBuilder)Mockito.mock(SetJobRetriesBuilder.class);
        Mockito.when((Object)this.mockManagementService.setJobRetries(ArgumentMatchers.anyInt())).thenReturn((Object)this.mockSetJobRetriesBuilder);
        Mockito.when((Object)this.mockSetJobRetriesBuilder.jobId((String)ArgumentMatchers.any())).thenReturn((Object)this.mockSetJobRetriesBuilder);
        Mockito.when((Object)this.mockSetJobRetriesBuilder.jobIds((List)ArgumentMatchers.any())).thenReturn((Object)this.mockSetJobRetriesBuilder);
        Mockito.when((Object)this.mockSetJobRetriesBuilder.jobDefinitionId((String)ArgumentMatchers.any())).thenReturn((Object)this.mockSetJobRetriesBuilder);
        Mockito.when((Object)this.mockSetJobRetriesBuilder.dueDate((Date)ArgumentMatchers.any())).thenReturn((Object)this.mockSetJobRetriesBuilder);
    }

    private JobDefinitionQuery setUpMockJobDefinitionQuery(List<JobDefinition> mockedJobDefinitions) {
        JobDefinitionQuery sampleJobDefinitionQuery = (JobDefinitionQuery)Mockito.mock(JobDefinitionQuery.class);
        Mockito.when((Object)sampleJobDefinitionQuery.list()).thenReturn(mockedJobDefinitions);
        Mockito.when((Object)sampleJobDefinitionQuery.count()).thenReturn((Object)mockedJobDefinitions.size());
        if (mockedJobDefinitions.size() == 1) {
            Mockito.when((Object)((JobDefinition)sampleJobDefinitionQuery.singleResult())).thenReturn((Object)mockedJobDefinitions.get(0));
        }
        Mockito.when((Object)sampleJobDefinitionQuery.jobDefinitionId("aJobDefId")).thenReturn((Object)sampleJobDefinitionQuery);
        Mockito.when((Object)processEngine.getManagementService().createJobDefinitionQuery()).thenReturn((Object)sampleJobDefinitionQuery);
        Mockito.when((Object)this.mockManagementService.createJobDefinitionQuery()).thenReturn((Object)sampleJobDefinitionQuery);
        return sampleJobDefinitionQuery;
    }

    @Test
    public void testSimpleJobDefinitionGet() {
        RestAssured.given().pathParam("id", (Object)"aJobDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aJobDefId"), new Object[0]).body("processDefinitionId", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processDefinitionKey", Matchers.equalTo((Object)"aKey"), new Object[0]).body("jobType", Matchers.equalTo((Object)"aJobType"), new Object[0]).body("jobConfiguration", Matchers.equalTo((Object)"aJobConfig"), new Object[0]).body("activityId", Matchers.equalTo((Object)"anActivity"), new Object[0]).body("suspended", Matchers.equalTo((Object)true), new Object[0]).body("overridingJobPriority", Matchers.equalTo((Object)0x80000033L), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).when().get(SINGLE_JOB_DEFINITION_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockQuery)).jobDefinitionId("aJobDefId");
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockQuery)).singleResult();
    }

    @Test
    public void testJobDefinitionGetNullJobPriority() {
        JobDefinition mockJobDefinition = new MockJobDefinitionBuilder().id("aJobDefId").jobPriority(null).build();
        Mockito.when((Object)((JobDefinition)this.mockQuery.singleResult())).thenReturn((Object)mockJobDefinition);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aJobDefId"), new Object[0]).body("jobPriority", Matchers.nullValue(), new Object[0]).when().get(SINGLE_JOB_DEFINITION_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testJobDefinitionGetIdDoesntExist() {
        JobDefinitionQuery invalidQueryNonExistingJobDefinition = (JobDefinitionQuery)Mockito.mock(JobDefinitionQuery.class);
        Mockito.when((Object)this.mockManagementService.createJobDefinitionQuery().jobDefinitionId("aNonExistingJobDefId")).thenReturn((Object)invalidQueryNonExistingJobDefinition);
        Mockito.when((Object)((JobDefinition)invalidQueryNonExistingJobDefinition.singleResult())).thenReturn(null);
        String jobDefinitionId = "aNonExistingJobDefId";
        RestAssured.given().pathParam("id", (Object)jobDefinitionId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Job Definition with id " + jobDefinitionId + " does not exist")), new Object[0]).when().get(SINGLE_JOB_DEFINITION_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionExcludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeJobs", false);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionExcludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", false);
        params.put("executionDate", MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(false);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionIncludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionIncludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        params.put("executionDate", MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateThrowProcessEngineException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeJobs", false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateNonParseableDateFormat() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Job Definition with id aNonExistingJobDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByIdThrowsAuthorizationException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeJobs", false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionExcludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeJobs", false);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(false);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionExcludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", false);
        params.put("executionDate", MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(false);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionIncludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionIncludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        params.put("executionDate", MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendThrowsProcessEngineException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeJobs", false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendNonParseableDateFormat() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Job Definition with id aNonExistingJobDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendWithMultipleByParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("processDefinitionKey", "aKey");
        String message = "Only one of jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByIdThrowsAuthorizationException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeJobs", false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionByProcessDefinitionKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Job Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyWithAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionByProcessDefinitionKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Job Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyWithAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionIdIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testDelayedActivateJobDefinitionByProcessDefinitionIdIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeJobs", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionIdWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Job Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByProcessDefinitionIdWithAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionIdIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testDelayedSuspendJobDefinitionByProcessDefinitionIdIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeJobs", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((UpdateJobDefinitionSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).executionDate(executionDate);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).includeJobs(true);
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionIdWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Job Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByProcessDefinitionIdWithAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobDefinitionSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobDefinitionByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobDefinitionId", "aJobDefId");
        String message = "Either processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        String message = "Either processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobDefinitionByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSetJobRetries() {
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put("retries", 3);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).jobDefinitionId("aJobDefId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetJobRetriesWithDueDate() {
        HashMap<String, Comparable<Integer>> retriesVariableJson = new HashMap<String, Comparable<Integer>>();
        retriesVariableJson.put("retries", Integer.valueOf(3));
        Date newDueDate = new Date(1675752840000L);
        retriesVariableJson.put("dueDate", newDueDate);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).jobDefinitionId("aJobDefId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).dueDate(newDueDate);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetJobRetriesWithNullDueDate() {
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put("retries", 3);
        retriesVariableJson.put("dueDate", null);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).jobDefinitionId("aJobDefId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).dueDate(null);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetJobRetriesExceptionExpected() {
        ((SetJobRetriesBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("job definition not found")}).when((Object)this.mockSetJobRetriesBuilder)).execute();
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put("retries", 3);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"job definition not found"), new Object[0]).when().put(JOB_DEFINITION_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).jobDefinitionId("aNonExistingJobDefId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetJobRetriesAuthorizationException() {
        String expectedMessage = "expected exception message";
        ((SetJobRetriesBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockSetJobRetriesBuilder)).execute();
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put("retries", 3);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).jobDefinitionId("aNonExistingJobDefId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetJobPriority() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 0x80000033L);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition("aJobDefId", 0x80000033L, false);
    }

    @Test
    public void testSetJobPriorityToExtremeValue() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", Long.MAX_VALUE);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition("aJobDefId", Long.MAX_VALUE, false);
    }

    @Test
    public void testSetJobPriorityIncludeExistingJobs() {
        HashMap<String, Constable> priorityJson = new HashMap<String, Constable>();
        priorityJson.put("priority", Long.valueOf(0x80000033L));
        priorityJson.put("includeJobs", Boolean.valueOf(true));
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition("aJobDefId", 0x80000033L, true);
    }

    @Test
    public void testSetJobPriorityExceptionExpected() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition((String)ArgumentMatchers.eq((Object)"aJobDefId"), ArgumentMatchers.eq((long)0x80000033L), ArgumentMatchers.anyBoolean());
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 0x80000033L);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition("aJobDefId", 0x80000033L, false);
    }

    @Test
    public void testSetNonExistingJobDefinitionPriority() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException(expectedMessage)}).when((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition((String)ArgumentMatchers.eq((Object)"aNonExistingJobDefId"), ArgumentMatchers.eq((long)0x80000033L), ArgumentMatchers.anyBoolean());
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 0x80000033L);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testSetJobPriorityAuthorizationException() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockManagementService)).setOverridingJobPriorityForJobDefinition((String)ArgumentMatchers.eq((Object)"aJobDefId"), ArgumentMatchers.eq((long)0x80000033L), ArgumentMatchers.anyBoolean());
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 0x80000033L);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testResetJobPriority() {
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).clearOverridingJobPriorityForJobDefinition("aJobDefId");
    }

    @Test
    public void testResetJobPriorityIncludeJobsNotAllowed() {
        HashMap<String, Boolean> priorityJson = new HashMap<String, Boolean>();
        priorityJson.put("priority", null);
        priorityJson.put("includeJobs", true);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot reset priority for job definition aJobDefId with includeJobs=true"), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testResetJobPriorityExceptionExpected() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).clearOverridingJobPriorityForJobDefinition("aJobDefId");
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testResetNonExistingJobDefinitionPriority() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException(expectedMessage)}).when((Object)this.mockManagementService)).clearOverridingJobPriorityForJobDefinition("aNonExistingJobDefId");
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testResetJobPriorityAuthorizationException() {
        String expectedMessage = "expected exception message";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockManagementService)).clearOverridingJobPriorityForJobDefinition("aJobDefId");
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aJobDefId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_DEFINITION_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockQuery = this.setUpMockJobDefinitionQuery(this.createMockJobDefinitionsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_RESOURCE_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List jobDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobDefinitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockQuery = this.setUpMockJobDefinitionQuery(this.createMockJobDefinitionsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_RESOURCE_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List jobDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobDefinitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<JobDefinition> createMockJobDefinitionsTwoTenants() {
        return Arrays.asList(MockProvider.mockJobDefinition().tenantId("aTenantId").build(), MockProvider.mockJobDefinition().tenantId("anotherTenantId").build());
    }
}

