/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.identity.TenantDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TenantRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String SERVICE_URL = "/rest-test/tenant";
    protected static final String TENANT_URL = "/rest-test/tenant/{id}";
    protected static final String TENANT_CREATE_URL = "/rest-test/tenant/create";
    protected static final String TENANT_USER_MEMBERS_URL = "/rest-test/tenant/{id}/user-members";
    protected static final String TENANT_USER_MEMBER_URL = "/rest-test/tenant/{id}/user-members/{userId}";
    protected static final String TENANT_GROUP_MEMBERS_URL = "/rest-test/tenant/{id}/group-members";
    protected static final String TENANT_GROUP_MEMBER_URL = "/rest-test/tenant/{id}/group-members/{groupId}";
    protected IdentityService identityServiceMock;
    protected AuthorizationService authorizationServiceMock;
    protected ProcessEngineConfiguration processEngineConfigurationMock;
    protected Tenant mockTenant;
    protected TenantQuery mockQuery;

    @Before
    public void setupData() {
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityService.class);
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        this.processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
        this.mockTenant = MockProvider.createMockTenant();
        this.mockQuery = this.setUpMockQuery(this.mockTenant);
    }

    protected TenantQuery setUpMockQuery(Tenant tenant) {
        TenantQuery query = (TenantQuery)Mockito.mock(TenantQuery.class);
        Mockito.when((Object)query.tenantId(Mockito.anyString())).thenReturn((Object)query);
        Mockito.when((Object)((Tenant)query.singleResult())).thenReturn((Object)tenant);
        Mockito.when((Object)this.identityServiceMock.createTenantQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void getTenant() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("name", Matchers.equalTo((Object)"aTenantName"), new Object[0]).when().get(TENANT_URL, new Object[0]);
    }

    @Test
    public void getNonExistingTenant() {
        Mockito.when((Object)((Tenant)this.mockQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingTenant").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Tenant with id aNonExistingTenant does not exist"), new Object[0]).when().get(TENANT_URL, new Object[0]);
    }

    @Test
    public void deleteTenant() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(TENANT_URL, new Object[0]);
    }

    @Test
    public void deleteNonExistingTenant() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingTenant").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(TENANT_URL, new Object[0]);
    }

    @Test
    public void deleteTenantThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).deleteTenant("aTenantId");
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(TENANT_URL, new Object[0]);
    }

    @Test
    public void updateTenant() {
        Tenant updatedTenant = MockProvider.createMockTenant();
        Mockito.when((Object)updatedTenant.getName()).thenReturn((Object)"updatedName");
        RestAssured.given().pathParam("id", (Object)"aTenantId").body((Object)TenantDto.fromTenant((Tenant)updatedTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(TENANT_URL, new Object[0]);
        ((Tenant)Mockito.verify((Object)this.mockTenant)).setName(updatedTenant.getName());
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveTenant(this.mockTenant);
    }

    @Test
    public void updateNonExistingTenant() {
        Tenant updatedTenant = MockProvider.createMockTenant();
        Mockito.when((Object)updatedTenant.getName()).thenReturn((Object)"updatedName");
        Mockito.when((Object)((Tenant)this.mockQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingTenant").body((Object)TenantDto.fromTenant((Tenant)updatedTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Tenant with id aNonExistingTenant does not exist"), new Object[0]).when().put(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveTenant((Tenant)Mockito.any(Tenant.class));
    }

    @Test
    public void updateTenantThrowsAuthorizationException() {
        Tenant updatedTenant = MockProvider.createMockTenant();
        Mockito.when((Object)updatedTenant.getName()).thenReturn((Object)"updatedName");
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).saveTenant((Tenant)Mockito.any(Tenant.class));
        RestAssured.given().pathParam("id", (Object)"aTenantId").body((Object)TenantDto.fromTenant((Tenant)updatedTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(TENANT_URL, new Object[0]);
    }

    @Test
    public void createTenant() {
        Tenant newTenant = MockProvider.createMockTenant();
        Mockito.when((Object)this.identityServiceMock.newTenant("aTenantId")).thenReturn((Object)newTenant);
        RestAssured.given().body((Object)TenantDto.fromTenant((Tenant)this.mockTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TENANT_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newTenant("aTenantId");
        ((Tenant)Mockito.verify((Object)newTenant)).setName("aTenantName");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveTenant(newTenant);
    }

    @Test
    public void createExistingTenant() {
        Tenant newTenant = MockProvider.createMockTenant();
        Mockito.when((Object)this.identityServiceMock.newTenant("aTenantId")).thenReturn((Object)newTenant);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(message)}).when((Object)this.identityServiceMock)).saveTenant(newTenant);
        RestAssured.given().body((Object)TenantDto.fromTenant((Tenant)newTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TENANT_CREATE_URL, new Object[0]);
    }

    @Test
    public void createTenantThrowsAuthorizationException() {
        Tenant newTenant = MockProvider.createMockTenant();
        String message = "exception expected";
        Mockito.when((Object)this.identityServiceMock.newTenant("aTenantId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().body((Object)TenantDto.fromTenant((Tenant)newTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TENANT_CREATE_URL, new Object[0]);
    }

    @Test
    public void saveTenantThrowsAuthorizationException() {
        Tenant newTenant = MockProvider.createMockTenant();
        Mockito.when((Object)this.identityServiceMock.newTenant("aTenantId")).thenReturn((Object)newTenant);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).saveTenant(newTenant);
        RestAssured.given().body((Object)TenantDto.fromTenant((Tenant)newTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TENANT_CREATE_URL, new Object[0]);
    }

    @Test
    public void userRestServiceOptionUnauthenticated() {
        String fullAuthorizationUrl = this.getFullAuthorizationUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void userRestServiceOptionUnauthorized() {
        String fullAuthorizationUrl = this.getFullAuthorizationUrl();
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT, "*")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void userRestServiceOptionAuthorized() {
        String fullAuthorizationUrl = this.getFullAuthorizationUrl();
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT, "*")).thenReturn((Object)true);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void userRestServiceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = this.getFullAuthorizationUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void tenantResourceOptionsUnauthenticated() {
        String fullTenantUrl = this.getFullAuthorizationTenantUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void tenantResourceOptionsUnauthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT, "aTenantId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.TENANT, "aTenantId")).thenReturn((Object)false);
        String fullTenantUrl = this.getFullAuthorizationTenantUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.TENANT, "aTenantId");
    }

    @Test
    public void tenantResourceOptionsAuthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT, "aTenantId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.TENANT, "aTenantId")).thenReturn((Object)false);
        String fullTenantUrl = this.getFullAuthorizationTenantUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.TENANT, "aTenantId");
    }

    @Test
    public void tenantResourceOptionsWithAuthorizationDisabled() {
        String fullTenantUrl = this.getFullAuthorizationTenantUrl();
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullTenantUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(TENANT_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void createTenantUserMembership() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(TENANT_USER_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).createTenantUserMembership("aTenantId", "userId");
    }

    @Test
    public void createTenantGroupMembership() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("groupId", (Object)"groupId1").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(TENANT_GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).createTenantGroupMembership("aTenantId", "groupId1");
    }

    @Test
    public void createTenantUserMembershipThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).createTenantUserMembership("aTenantId", "userId");
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(TENANT_USER_MEMBER_URL, new Object[0]);
    }

    @Test
    public void deleteTenantUserMembership() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(TENANT_USER_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).deleteTenantUserMembership("aTenantId", "userId");
    }

    @Test
    public void deleteTenantGroupMembership() {
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("groupId", (Object)"groupId1").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(TENANT_GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).deleteTenantGroupMembership("aTenantId", "groupId1");
    }

    @Test
    public void deleteTenantGroupMembershipThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).deleteTenantGroupMembership("aTenantId", "groupId1");
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("groupId", (Object)"groupId1").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(TENANT_GROUP_MEMBER_URL, new Object[0]);
    }

    @Test
    public void tenantUserMembershipResourceOptionsUnauthenticated() {
        String fullMembersUrl = this.getFullAuthorizationTenantUrl() + "/user-members";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(TENANT_USER_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void tenantUserMembershipResourceOptionsAuthorized() {
        String fullMembersUrl = this.getFullAuthorizationTenantUrl() + "/user-members";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)true);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(TENANT_USER_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
    }

    @Test
    public void tenantGroupMembershipResourceOptionsAuthorized() {
        String fullMembersUrl = this.getFullAuthorizationTenantUrl() + "/group-members";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)true);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(TENANT_GROUP_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
    }

    @Test
    public void tenantUserMembershipResourceOptionsUnauthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0]", Matchers.nullValue(), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).when().options(TENANT_USER_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
    }

    @Test
    public void tenantGroupMembershipResourceOptionsUnauthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0]", Matchers.nullValue(), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).when().options(TENANT_GROUP_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.TENANT_MEMBERSHIP, "aTenantId");
    }

    @Test
    public void tenantUserMembershipResourceOptionsWithAuthorizationDisabled() {
        String fullMembersUrl = this.getFullAuthorizationTenantUrl() + "/user-members";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(TENANT_USER_MEMBERS_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void failToCreateTenantForReadOnlyService() {
        Tenant newTenant = MockProvider.createMockTenant();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().body((Object)TenantDto.fromTenant((Tenant)newTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().post(TENANT_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).newTenant("aTenantId");
    }

    @Test
    public void failToUpdateTenantForReadOnlyService() {
        Tenant updatedTenant = MockProvider.createMockTenant();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").body((Object)TenantDto.fromTenant((Tenant)updatedTenant)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().put(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveTenant(this.mockTenant);
    }

    @Test
    public void failToDeleteTenantForReadOnlyService() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().delete(TENANT_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteTenant("aTenantId");
    }

    @Test
    public void failToCreateTenantUserMembershipForReadOnlyService() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().put(TENANT_USER_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).createTenantUserMembership("aTenantId", "userId");
    }

    @Test
    public void failToCreateTenantGroupMembershipForReadOnlyService() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("groupId", (Object)"groupId1").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().put(TENANT_GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).createTenantGroupMembership("aTenantId", "groupId1");
    }

    @Test
    public void failToDeleteTenantUserMembershipForReadOnlyService() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().delete(TENANT_USER_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteTenantUserMembership("aTenantId", "userId");
    }

    @Test
    public void failToDeleteTenantGroupMembershipForReadOnlyService() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aTenantId").pathParam("groupId", (Object)"groupId1").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().delete(TENANT_GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteTenantGroupMembership("aTenantId", "groupId1");
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(Mockito.anyString(), Mockito.anyList(), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class));
    }

    protected String getFullAuthorizationUrl() {
        return "http://localhost:" + PORT + "/rest-test" + "/tenant";
    }

    protected String getFullAuthorizationTenantUrl() {
        return this.getFullAuthorizationUrl() + "/" + "aTenantId";
    }
}

