/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricActivityStatisticsRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history";
    protected static final String HISTORIC_ACTIVITY_STATISTICS_URL = "/rest-test/history/process-definition/{id}/statistics";
    private HistoricActivityStatisticsQuery historicActivityStatisticsQuery;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoricActivityStatisticsMock();
    }

    private void setupHistoricActivityStatisticsMock() {
        List<HistoricActivityStatistics> mocks = MockProvider.createMockHistoricActivityStatistics();
        this.historicActivityStatisticsQuery = (HistoricActivityStatisticsQuery)Mockito.mock(HistoricActivityStatisticsQueryImpl.class);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricActivityStatisticsQuery((String)Mockito.eq((Object)"aProcDefId"))).thenReturn((Object)this.historicActivityStatisticsQuery);
        Mockito.when((Object)this.historicActivityStatisticsQuery.unlimitedList()).thenReturn(mocks);
    }

    @Test
    public void testHistoricActivityStatisticsRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", Matchers.is((Object)2), new Object[0]).body("id", Matchers.hasItems((Object[])new String[]{"anActivity", "anotherActivity"}), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testAdditionalCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalCompleteScopeOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalStartedAfterOption() {
        Date testDate = new Date(0L);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("startedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(testDate)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).startedAfter(testDate);
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalStartedBeforeOption() {
        Date testDate = new Date(0L);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("startedBefore", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(testDate)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).startedBefore(testDate);
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalFinishedAfterOption() {
        Date testDate = new Date(0L);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("finishedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(testDate)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).finishedAfter(testDate);
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalFinishedBeforeOption() {
        Date testDate = new Date(0L);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("finishedBefore", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(testDate)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).finishedBefore(testDate);
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testAdditionalCompleteScopeAndCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicActivityStatisticsQuery});
    }

    @Test
    public void testAdditionalCompleteScopeAndFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicActivityStatisticsQuery});
    }

    @Test
    public void testAdditionalCanceledAndFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("canceled", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicActivityStatisticsQuery});
    }

    @Test
    public void testAdditionalCompleteScopeAndFinishedAndCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicActivityStatisticsQuery});
    }

    @Test
    public void testAdditionalCompleteScopeAndFinishedAndCanceledOptionFalse() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"false"}).queryParam("finished", new Object[]{"false"}).queryParam("canceled", new Object[]{"false"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicActivityStatisticsQuery});
    }

    @Test
    public void testProcessInstanceIdInFilter() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("processInstanceIdIn", new Object[]{"foo,bar"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).processInstanceIdIn(new String[]{"foo", "bar"});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testIncidentsFilter() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("incidents", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeIncidents();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testSimpleTaskQuery() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        String content = response.asString();
        List result = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertNotNull(result.get(1));
        String id = JsonPath.from((String)content).getString("[0].id");
        long instances = JsonPath.from((String)content).getLong("[0].instances");
        long canceled = JsonPath.from((String)content).getLong("[0].canceled");
        long finished = JsonPath.from((String)content).getLong("[0].finished");
        long completeScope = JsonPath.from((String)content).getLong("[0].completeScope");
        long openIncidents = JsonPath.from((String)content).getLong("[0].openIncidents");
        long resolvedIncidents = JsonPath.from((String)content).getLong("[0].resolvedIncidents");
        long deletedIncidents = JsonPath.from((String)content).getLong("[0].deletedIncidents");
        Assert.assertEquals((Object)"anActivity", (Object)id);
        Assert.assertEquals((long)123L, (long)instances);
        Assert.assertEquals((long)125L, (long)canceled);
        Assert.assertEquals((long)124L, (long)finished);
        Assert.assertEquals((long)126L, (long)completeScope);
        Assert.assertEquals((long)0L, (long)openIncidents);
        Assert.assertEquals((long)0L, (long)resolvedIncidents);
        Assert.assertEquals((long)0L, (long)deletedIncidents);
        id = JsonPath.from((String)content).getString("[1].id");
        instances = JsonPath.from((String)content).getLong("[1].instances");
        canceled = JsonPath.from((String)content).getLong("[1].canceled");
        finished = JsonPath.from((String)content).getLong("[1].finished");
        completeScope = JsonPath.from((String)content).getLong("[1].completeScope");
        openIncidents = JsonPath.from((String)content).getLong("[1].openIncidents");
        resolvedIncidents = JsonPath.from((String)content).getLong("[1].resolvedIncidents");
        deletedIncidents = JsonPath.from((String)content).getLong("[1].deletedIncidents");
        Assert.assertEquals((Object)"anotherActivity", (Object)id);
        Assert.assertEquals((long)127L, (long)instances);
        Assert.assertEquals((long)129L, (long)canceled);
        Assert.assertEquals((long)128L, (long)finished);
        Assert.assertEquals((long)130L, (long)completeScope);
        Assert.assertEquals((long)1L, (long)openIncidents);
        Assert.assertEquals((long)2L, (long)resolvedIncidents);
        Assert.assertEquals((long)3L, (long)deletedIncidents);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortOrder() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"invalid"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'sortOrder' to value 'invalid'"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortByParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).queryParam("sortBy", new Object[]{"invalid"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'sortBy' to value 'invalid'"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testValidSortingParameters() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).orderByActivityId();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).asc();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"desc"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).orderByActivityId();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).desc();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).unlimitedList();
        inOrder.verifyNoMoreInteractions();
    }
}

