/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.servlet.ServletContextEvent;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksDto;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksExtendedDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.impl.FetchAndLockContextListener;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class FetchAndLockRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    private static final String FETCH_EXTERNAL_TASK_URL = "/rest-test/external-task/fetchAndLock";
    @Mock
    private ExternalTaskService externalTaskService;
    @Mock
    private ExternalTaskQueryTopicBuilder fetchTopicBuilder;
    @Mock
    private IdentityService identityServiceMock;
    private LockedExternalTask lockedExternalTaskMock;
    private List<String> groupIds;
    private List<String> tenantIds;

    @Before
    public void setUpRuntimeData() {
        Mockito.when((Object)processEngine.getExternalTaskService()).thenReturn((Object)this.externalTaskService);
        this.lockedExternalTaskMock = MockProvider.createMockLockedExternalTask();
        Mockito.when((Object)this.externalTaskService.fetchAndLock(Mockito.anyInt(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.topic((String)Mockito.any(String.class), Mockito.anyLong())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.variables(Mockito.anyList())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.enableCustomObjectDeserialization()).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionVersionTag(Mockito.anyString())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        List<Group> groupMocks = MockProvider.createMockGroups();
        this.groupIds = groupMocks.stream().map(Group::getId).collect(Collectors.toList());
        List<Tenant> tenantMocks = Collections.singletonList(MockProvider.createMockTenant());
        this.tenantIds = tenantMocks.stream().map(Tenant::getId).collect(Collectors.toList());
        new FetchAndLockContextListener().contextInitialized((ServletContextEvent)Mockito.mock(ServletContextEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
    }

    @Test
    public void shouldFetchAndLock() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(new ArrayList<LockedExternalTask>(Collections.singleton(this.lockedExternalTaskMock)));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(null, true, true, false);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", IsEqual.equalTo((Object)"anExternalTaskId"), new Object[0]).body("[0].topicName", IsEqual.equalTo((Object)"aTopic"), new Object[0]).body("[0].workerId", IsEqual.equalTo((Object)"aWorkerId"), new Object[0]).body("[0].lockExpirationTime", IsEqual.equalTo((Object)MockProvider.EXTERNAL_TASK_LOCK_EXPIRATION_TIME), new Object[0]).body("[0].processInstanceId", IsEqual.equalTo((Object)"aProcInstId"), new Object[0]).body("[0].executionId", IsEqual.equalTo((Object)"anExecutionId"), new Object[0]).body("[0].activityId", IsEqual.equalTo((Object)"anActivity"), new Object[0]).body("[0].activityInstanceId", IsEqual.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("[0].processDefinitionId", IsEqual.equalTo((Object)"aProcDefId"), new Object[0]).body("[0].processDefinitionKey", IsEqual.equalTo((Object)"aKey"), new Object[0]).body("[0].tenantId", IsEqual.equalTo((Object)"aTenantId"), new Object[0]).body("[0].retries", IsEqual.equalTo((Object)MockProvider.EXTERNAL_TASK_RETRIES), new Object[0]).body("[0].errorMessage", IsEqual.equalTo((Object)"some error"), new Object[0]).body("[0].errorMessage", IsEqual.equalTo((Object)"some error"), new Object[0]).body("[0].priority", IsEqual.equalTo((Object)2147484113L), new Object[0]).body("[0].variables.aVariableInstanceName", IsNull.notNullValue(), new Object[0]).body("[0].variables.aVariableInstanceName.value", IsEqual.equalTo((Object)((String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue())), new Object[0]).body("[0].variables.aVariableInstanceName.type", IsEqual.equalTo((Object)"String"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Collections.singletonList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void shouldFetchWithoutVariables() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(new ArrayList<LockedExternalTask>(Collections.singleton(this.lockedExternalTaskMock)));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(null);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", IsEqual.equalTo((Object)"anExternalTaskId"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void shouldFetchWithCustomObjectDeserializationEnabled() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(new ArrayList<LockedExternalTask>(Collections.singleton(this.lockedExternalTaskMock)));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(null, false, true, true);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Collections.singletonList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).enableCustomObjectDeserialization();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void shouldThrowInvalidRequestExceptionOnMaxTimeoutExceeded() {
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(1800001L);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().body("type", IsEqual.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"The asynchronous response timeout cannot be set to a value greater than "), new Object[0]).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void shouldThrowProcessEngineExceptionDuringTimeout() {
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Collections.emptyList()).thenReturn(Collections.emptyList()).thenThrow(new Throwable[]{new ProcessEngineException("anExceptionMessage")});
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().body("type", IsEqual.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)"anExceptionMessage"), new Object[0]).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskQueryTopicBuilder)Mockito.verify((Object)this.fetchTopicBuilder, (VerificationMode)Mockito.atLeastOnce())).execute();
    }

    @Test
    public void shouldThrowProcessEngineExceptionNotDuringTimeout() {
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenThrow(new Throwable[]{new ProcessEngineException("anExceptionMessage")});
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().body("type", IsEqual.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)"anExceptionMessage"), new Object[0]).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskQueryTopicBuilder)Mockito.verify((Object)this.fetchTopicBuilder, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void shouldResponseImmediatelyDueToAvailableTasks() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(new ArrayList<LockedExternalTask>(Collections.singleton(this.lockedExternalTaskMock)));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().body("size()", Matchers.is((Object)1), new Object[0]).statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Ignore
    @Test
    public void shouldSetAuthenticationProperly() {
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)new Authentication("userId", this.groupIds, this.tenantIds));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Authentication.class);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.atLeastOnce())).setAuthentication((Authentication)argumentCaptor.capture());
        MatcherAssert.assertThat((Object)((Authentication)argumentCaptor.getValue()).getUserId(), (Matcher)Matchers.is((Object)"userId"));
        MatcherAssert.assertThat((Object)((Authentication)argumentCaptor.getValue()).getGroupIds(), (Matcher)Matchers.is(this.groupIds));
        MatcherAssert.assertThat((Object)((Authentication)argumentCaptor.getValue()).getTenantIds(), (Matcher)Matchers.is(this.tenantIds));
    }

    @Test
    public void shouldReturnInternalServerErrorResponseJsonWithTypeAndMessage() {
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenThrow(new Throwable[]{new IllegalArgumentException("anExceptionMessage")});
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().body("type", IsEqual.equalTo((Object)IllegalArgumentException.class.getSimpleName()), new Object[0]).body("message", IsEqual.equalTo((Object)"anExceptionMessage"), new Object[0]).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskQueryTopicBuilder)Mockito.verify((Object)this.fetchTopicBuilder, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void shouldFetchAndLockByProcessDefinitionVersionTag() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(new ArrayList<LockedExternalTask>(Collections.singleton(this.lockedExternalTaskMock)));
        FetchExternalTasksExtendedDto fetchExternalTasksDto = this.createDto(500L);
        for (FetchExternalTasksDto.FetchExternalTaskTopicDto topic : fetchExternalTasksDto.getTopics()) {
            topic.setProcessDefinitionVersionTag("version");
        }
        RestAssured.given().contentType(ContentType.JSON).body((Object)fetchExternalTasksDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskQueryTopicBuilder)Mockito.verify((Object)this.fetchTopicBuilder)).processDefinitionVersionTag("version");
    }

    private FetchExternalTasksExtendedDto createDto(Long responseTimeout) {
        return this.createDto(responseTimeout, false, false, false);
    }

    private FetchExternalTasksExtendedDto createDto(Long responseTimeout, boolean usePriority, boolean withVariables, boolean withDeserialization) {
        FetchExternalTasksExtendedDto fetchExternalTasksDto = new FetchExternalTasksExtendedDto();
        if (responseTimeout != null) {
            fetchExternalTasksDto.setAsyncResponseTimeout(responseTimeout);
        }
        fetchExternalTasksDto.setMaxTasks(5);
        fetchExternalTasksDto.setWorkerId("aWorkerId");
        fetchExternalTasksDto.setUsePriority(usePriority);
        FetchExternalTasksDto.FetchExternalTaskTopicDto topicDto = new FetchExternalTasksDto.FetchExternalTaskTopicDto();
        fetchExternalTasksDto.setTopics(Collections.singletonList(topicDto));
        topicDto.setTopicName("aTopicName");
        topicDto.setLockDuration(12354L);
        if (withVariables) {
            topicDto.setVariables(Collections.singletonList("aVariableInstanceName"));
        }
        topicDto.setDeserializeValues(withDeserialization);
        fetchExternalTasksDto.setTopics(Collections.singletonList(topicDto));
        return fetchExternalTasksDto;
    }
}

