/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import org.camunda.bpm.engine.rest.helper.NoIntermediaryInvocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.verification.VerificationMode;

public class NoIntermediaryInvocationTest {
    protected Foo foo;

    @Before
    public void setUp() {
        this.foo = (Foo)Mockito.mock(Foo.class);
    }

    @Test
    public void testSucceess() {
        this.foo.getFoo();
        this.foo.getBar();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.foo});
        ((Foo)inOrder.verify((Object)this.foo)).getFoo();
        ((Foo)inOrder.verify((Object)this.foo, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).getBar();
    }

    @Test
    public void testFailureWhenInvocationNotPresent() {
        this.foo.getFoo();
        this.foo.getBaz();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.foo});
        ((Foo)inOrder.verify((Object)this.foo)).getFoo();
        try {
            ((Foo)inOrder.verify((Object)this.foo, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).getBar();
            Assert.fail((String)"should not verify");
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            // empty catch block
        }
    }

    @Test
    public void testFailureWhenInvocationNotPresentCase2() {
        this.foo.getFoo();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.foo});
        ((Foo)inOrder.verify((Object)this.foo)).getFoo();
        try {
            ((Foo)inOrder.verify((Object)this.foo, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).getBar();
            Assert.fail((String)"should not verify");
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            // empty catch block
        }
    }

    @Test
    public void testFailureOnWrongInvocationOrder() {
        this.foo.getBar();
        this.foo.getFoo();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.foo});
        ((Foo)inOrder.verify((Object)this.foo)).getFoo();
        try {
            ((Foo)inOrder.verify((Object)this.foo, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).getBar();
            Assert.fail((String)"should not verify");
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            // empty catch block
        }
    }

    @Test
    public void testFailureWithIntermittentInvocations() {
        this.foo.getFoo();
        this.foo.getBaz();
        this.foo.getBar();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.foo});
        ((Foo)inOrder.verify((Object)this.foo)).getFoo();
        try {
            ((Foo)inOrder.verify((Object)this.foo, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).getBar();
            Assert.fail((String)"should not verify");
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            // empty catch block
        }
    }

    public static interface Foo {
        public String getFoo();

        public String getBar();

        public String getBaz();
    }
}

