/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class IncidentRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String INCIDENT_URL = "/rest-test/incident";
    protected static final String SINGLE_INCIDENT_URL = "/rest-test/incident/{id}";
    protected static final String INCIDENT_ANNOTATION_URL = "/rest-test/incident/{id}/annotation";
    private RuntimeServiceImpl mockRuntimeService;
    private IncidentQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        List<Incident> incidents = MockProvider.createMockIncidents();
        this.mockedQuery = this.setupMockIncidentQuery(incidents);
    }

    private IncidentQuery setupMockIncidentQuery(List<Incident> incidents) {
        IncidentQuery sampleQuery = (IncidentQuery)Mockito.mock(IncidentQuery.class);
        Mockito.when((Object)sampleQuery.incidentId(Mockito.anyString())).thenReturn((Object)sampleQuery);
        Mockito.when((Object)((Incident)sampleQuery.singleResult())).thenReturn((Object)((Incident)Mockito.mock(Incident.class)));
        this.mockRuntimeService = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.mockRuntimeService);
        Mockito.when((Object)this.mockRuntimeService.createIncidentQuery()).thenReturn((Object)sampleQuery);
        return sampleQuery;
    }

    @Test
    public void testGetIncident() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).createIncidentQuery();
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentId("anIncidentId");
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).singleResult();
    }

    @Test
    public void testGetUnexistingIncident() {
        Mockito.when((Object)((Incident)this.mockedQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).createIncidentQuery();
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentId("anIncidentId");
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).singleResult();
    }

    @Test
    public void testResolveIncident() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).resolveIncident("anIncidentId");
    }

    @Test
    public void testResolveUnexistingIncident() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException()}).when((Object)this.mockRuntimeService)).resolveIncident(Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().delete(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).resolveIncident("anIncidentId");
    }

    @Test
    public void shouldSetAnnotation() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").contentType("application/json").body("{ \"annotation\": \"anAnnotation\" }").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(INCIDENT_ANNOTATION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).setAnnotationForIncidentById("anIncidentId", "anAnnotation");
    }

    @Test
    public void shouldThrowNotValidExceptionWhenSetAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected")}).when((Object)this.mockRuntimeService)).setAnnotationForIncidentById(Mockito.anyString(), Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").contentType("application/json").body("{ \"annotation\": \"anAnnotation\" }").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(INCIDENT_ANNOTATION_URL, new Object[0]);
    }

    @Test
    public void shouldThrowAuthorizationExceptionWhenSetAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("expected")}).when((Object)this.mockRuntimeService)).setAnnotationForIncidentById(Mockito.anyString(), Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").contentType("application/json").body("{ \"annotation\": \"anAnnotation\" }").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).when().put(INCIDENT_ANNOTATION_URL, new Object[0]);
    }

    @Test
    public void shouldThrowBadRequestExceptionWhenSetAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("expected")}).when((Object)this.mockRuntimeService)).setAnnotationForIncidentById(Mockito.anyString(), Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").contentType("application/json").body("{ \"annotation\": \"anAnnotation\" }").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(INCIDENT_ANNOTATION_URL, new Object[0]);
    }

    @Test
    public void shouldClearAnnotation() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(INCIDENT_ANNOTATION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).clearAnnotationForIncidentById("anIncidentId");
    }

    @Test
    public void shouldThrowNotValidExceptionWhenClearAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected")}).when((Object)this.mockRuntimeService)).clearAnnotationForIncidentById(Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().delete(INCIDENT_ANNOTATION_URL, new Object[0]);
    }

    @Test
    public void shouldThrowAuthorizationExceptionWhenClearAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("expected")}).when((Object)this.mockRuntimeService)).clearAnnotationForIncidentById(Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).when().delete(INCIDENT_ANNOTATION_URL, new Object[0]);
    }

    @Test
    public void shouldThrowBadRequestExceptionWhenClearAnnotation() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("expected")}).when((Object)this.mockRuntimeService)).clearAnnotationForIncidentById(Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().delete(INCIDENT_ANNOTATION_URL, new Object[0]);
    }
}

