/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.standalone;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import org.camunda.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=Parameterized.class)
public class AuthenticationFilterPathMatchingTest
extends AbstractRestServiceTest {
    protected static final String SERVICE_PATH = "/rest-test";
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected RepositoryService repositoryServiceMock;
    protected User userMock;
    protected List<String> groupIds;
    protected List<String> tenantIds;
    protected Filter authenticationFilter;
    protected String servletPath;
    protected String requestUrl;
    protected String engineName;
    protected boolean authenticationExpected;
    protected ProcessEngine currentEngine;

    public AuthenticationFilterPathMatchingTest(String servletPath, String requestUrl, String engineName, boolean authenticationExpected) {
        this.servletPath = servletPath;
        this.requestUrl = requestUrl;
        this.engineName = engineName;
        if (engineName == null) {
            this.engineName = "default";
        }
        this.authenticationExpected = authenticationExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getRequestUrls() {
        return Arrays.asList({"", "/engine/default/process-definition/and/a/longer/path", "default", true}, {"", "/engine/default/process-definition/and/a/longer/path", "default", true}, {"", "/engine/default/process-definition", "default", true}, {"", "/engine/someOtherEngine/process-definition", "someOtherEngine", true}, {"", "/engine/default/", "default", true}, {"", "/engine/default", "default", true}, {"", "/process-definition", "default", true}, {"", "/engine", null, false}, {"", "/engine/", null, false}, {"", "/", "default", true}, {"", "", "default", true}, {"/someservlet", "/engine/someengine/process-definition", "someengine", true});
    }

    @Before
    public void setup() throws ServletException {
        this.currentEngine = this.getProcessEngine(this.engineName);
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)this.currentEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)this.currentEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        this.userMock = MockProvider.createMockUser();
        List<Group> groupMocks = MockProvider.createMockGroups();
        this.groupIds = this.setupGroupQueryMock(groupMocks);
        List<Tenant> tenantMocks = Collections.singletonList(MockProvider.createMockTenant());
        this.tenantIds = this.setupTenantQueryMock(tenantMocks);
        GroupQuery mockGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.list()).thenReturn(groupMocks);
        this.setupFilter();
    }

    protected List<String> setupGroupQueryMock(List<Group> groups) {
        GroupQuery mockGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.list()).thenReturn(groups);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group groupMock : groups) {
            groupIds.add(groupMock.getId());
        }
        return groupIds;
    }

    protected List<String> setupTenantQueryMock(List<Tenant> tenants) {
        TenantQuery mockTenantQuery = (TenantQuery)Mockito.mock(TenantQuery.class);
        Mockito.when((Object)this.identityServiceMock.createTenantQuery()).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.userMember(Mockito.anyString())).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.includingGroupsOfUser(Mockito.anyBoolean())).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.list()).thenReturn(tenants);
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    protected void setupFilter() throws ServletException {
        MockFilterConfig config = new MockFilterConfig();
        config.addInitParameter("authentication-provider", HttpBasicAuthenticationProvider.class.getName());
        this.authenticationFilter = new ProcessEngineAuthenticationFilter();
        this.authenticationFilter.init((FilterConfig)config);
    }

    protected void applyFilter(MockHttpServletRequest request, MockHttpServletResponse response, String username, String password) throws IOException, ServletException {
        String credentials = username + ":" + password;
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])credentials.getBytes()))));
        MockFilterChain filterChain = new MockFilterChain();
        this.authenticationFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
    }

    @Test
    public void testHttpBasicAuthenticationCheck() throws IOException, ServletException {
        if (this.authenticationExpected) {
            Mockito.when((Object)this.identityServiceMock.checkPassword("userId", "s3cret")).thenReturn((Object)true);
        }
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(SERVICE_PATH + this.servletPath + this.requestUrl);
        request.setContextPath(SERVICE_PATH);
        request.setServletPath(this.servletPath);
        this.applyFilter(request, response, "userId", "s3cret");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        if (this.authenticationExpected) {
            ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).setAuthentication("userId", this.groupIds, this.tenantIds);
            ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).clearAuthentication();
        } else {
            ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).setAuthentication((String)Mockito.any(String.class), Mockito.anyList(), Mockito.anyList());
            ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).clearAuthentication();
        }
    }
}

