/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.camunda.bpm.engine.impl.cfg.auth.PermissionProvider;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.authorization.AuthorizationDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.ResourceUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthorizationRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String SERVICE_PATH = "/rest-test/authorization";
    protected static final String AUTH_CREATE_PATH = "/rest-test/authorization/create";
    protected static final String AUTH_CHECK_PATH = "/rest-test/authorization/check";
    protected static final String AUTH_RESOURCE_PATH = "/rest-test/authorization/{id}";
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected ProcessEngineConfigurationImpl processEngineConfigurationMock;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.processEngineConfigurationMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
        Mockito.when((Object)this.processEngineConfigurationMock.getPermissionProvider()).thenReturn((Object)new DefaultPermissionProvider());
    }

    @Test
    public void testIsUserAuthorizedTrue() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedFalse() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedBatchResource() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        String resourceName = Resources.BATCH.resourceName();
        int resourceType = Resources.BATCH.resourceType();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", resourceType);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{resourceName}).queryParam("resourceType", new Object[]{resourceType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)resourceName), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedProcessDefinitionResource() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        String resourceName = Resources.PROCESS_DEFINITION.resourceName();
        int resourceType = Resources.PROCESS_DEFINITION.resourceType();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", resourceType);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{resourceName}).queryParam("resourceType", new Object[]{resourceType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)resourceName), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedProcessInstanceResource() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        int resourceType = Resources.PROCESS_INSTANCE.resourceType();
        String resourceName = Resources.PROCESS_INSTANCE.resourceName();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", resourceType);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{resourceName}).queryParam("resourceType", new Object[]{resourceType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)resourceName), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedTaskResource() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        int resourceType = Resources.TASK.resourceType();
        String resourceName = Resources.TASK.resourceName();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", resourceType);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{resourceName}).queryParam("resourceType", new Object[]{resourceType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)resourceName), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedWithUserIdTrue() {
        ArrayList currentUserGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", currentUserGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        List<String> userToCheckGroups = this.setupGroupQueryMock();
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId2", userToCheckGroups, permission, (Resource)resource)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("userId", new Object[]{"userId2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId2", userToCheckGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedWithUserIdFalse() {
        ArrayList currentUserGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", currentUserGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        List<String> userToCheckGroups = this.setupGroupQueryMock();
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId2", userToCheckGroups, permission, (Resource)resource)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("userId", new Object[]{"userId2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId2", userToCheckGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedWithUserIdNoReadPermission() {
        ArrayList currentUserGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", currentUserGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        List<String> userToCheckGroups = this.setupGroupQueryMock();
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("userId", new Object[]{"userId2"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType("application/json").body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"You must have READ permission for Authorization resource."), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", currentUserGroups, (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized("userId2", userToCheckGroups, permission, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedNotValidPermission() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        String resourceName = Resources.BATCH.resourceName();
        int resourceType = Resources.BATCH.resourceType();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        RestAssured.given().queryParam("permissionName", new Object[]{Permissions.ACCESS.name()}).queryParam("resourceName", new Object[]{resourceName}).queryParam("resourceType", new Object[]{resourceType}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"The permission 'ACCESS' is not valid for 'BATCH' resource type."), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized("userId", exampleGroups, (Permission)Permissions.ACCESS, (Resource)resource);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedResourceIdTrue() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource, "exampleResourceId")).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("resourceId", new Object[]{"exampleResourceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo((Object)"exampleResourceId"), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource, "exampleResourceId");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedResourceIdFalse() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource, "exampleResourceId")).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("resourceId", new Object[]{"exampleResourceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo((Object)"exampleResourceId"), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, permission, (Resource)resource, "exampleResourceId");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedNoAuthentication() {
        ArrayList exampleGroups = new ArrayList();
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn(null);
        ResourceUtil resource = new ResourceUtil("exampleResource", 12345678);
        Permission permission = this.getPermissionProvider().getPermissionForName("READ", 12345678);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, permission, (Resource)resource)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)Mockito.any(String.class), (List)Mockito.any(List.class), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)Mockito.any(String.class), (List)Mockito.any(List.class), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class), (String)Mockito.any(String.class));
    }

    @Test
    public void testIsUserAuthorizedBadRequests() {
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        RestAssured.given().queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)Mockito.any(String.class), (List)Mockito.any(List.class), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)Mockito.any(String.class), (List)Mockito.any(List.class), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class), (String)Mockito.any(String.class));
    }

    @Test
    public void testCreateGlobalAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(0)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(0);
        ((Authorization)Mockito.verify((Object)authorization)).setUserId("*");
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateGrantAuthorization() {
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(1);
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setUserId(authorization.getUserId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateRevokeAuthorization() {
        Authorization authorization = MockProvider.createMockRevokeAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(2)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(2);
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setUserId(authorization.getUserId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateAuthorizationThrowsAuthorizationException() {
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(AUTH_CREATE_PATH, new Object[0]);
    }

    @Test
    public void testCreateAuthorizationNotValidPermission() {
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenReturn((Object)authorization);
        HashMap<String, Object> jsonBody = new HashMap<String, Object>();
        jsonBody.put("type", 1);
        jsonBody.put("permissions", Arrays.asList(Permissions.READ_INSTANCE.name()));
        jsonBody.put("userId", "userId,userId2");
        jsonBody.put("groupId", "groupId1,groupId2");
        jsonBody.put("resourceType", Resources.TASK.resourceType());
        jsonBody.put("resourceId", "exampleResourceId");
        RestAssured.given().body(jsonBody).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"The permission 'READ_INSTANCE' is not valid for 'TASK' resource type."), new Object[0]).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).createNewAuthorization(1);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).saveAuthorization(authorization);
    }

    @Test
    public void testSaveAuthorizationThrowsAuthorizationException() {
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization((Authorization)Mockito.any(Authorization.class))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(AUTH_CREATE_PATH, new Object[0]);
    }

    @Test
    public void testDeleteAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)authorizationQuery)).authorizationId("someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).deleteAuthorization("someAuthorizationId");
    }

    @Test
    public void testDeleteNonExistingAuthorization() {
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).deleteAuthorization("someAuthorizationId");
    }

    @Test
    public void testDeleteAuthorizationThrowsAuthorizationException() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        String message = "expected authorization exception";
        ((AuthorizationService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.authorizationServiceMock)).deleteAuthorization("someAuthorizationId");
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testUpdateAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)authorizationQuery)).authorizationId("someAuthorizationId");
        ((Authorization)Mockito.verify((Object)authorization)).setGroupId(dto.getGroupId());
        ((Authorization)Mockito.verify((Object)authorization)).setUserId(dto.getUserId());
        ((Authorization)Mockito.verify((Object)authorization)).setResourceId(dto.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization)).setResourceType(dto.getResourceType().intValue());
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testUpdateNonExistingAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn(null);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().put(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).saveAuthorization(authorization);
    }

    @Test
    public void testUpdateAuthorizationThrowsAuthorizationException() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization, (ProcessEngineConfiguration)this.processEngineConfigurationMock);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization((Authorization)Mockito.any(Authorization.class))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testUpdateAuthorizationNotValidPermission() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        HashMap<String, Object> jsonBody = new HashMap<String, Object>();
        jsonBody.put("permissions", Arrays.asList(Permissions.TASK_WORK.name()));
        jsonBody.put("userId", "userId,userId2");
        jsonBody.put("groupId", "groupId1,groupId2");
        jsonBody.put("resourceType", Resources.PROCESS_INSTANCE.resourceType());
        jsonBody.put("resourceId", "exampleResourceId");
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body(jsonBody).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"The permission 'TASK_WORK' is not valid for 'PROCESS_INSTANCE' resource type."), new Object[0]).when().put(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).saveAuthorization(authorization);
    }

    @Test
    public void testGetAuthorizationById() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("id", Matchers.equalTo((Object)authorization.getId()), new Object[0]).body("type", Matchers.equalTo((Object)authorization.getAuthorizationType()), new Object[0]).body("permissions[0]", Matchers.equalTo((Object)Permissions.READ.getName()), new Object[0]).body("permissions[1]", Matchers.equalTo((Object)Permissions.UPDATE.getName()), new Object[0]).body("userId", Matchers.equalTo((Object)authorization.getUserId()), new Object[0]).body("groupId", Matchers.equalTo((Object)authorization.getGroupId()), new Object[0]).body("resourceType", Matchers.equalTo((Object)authorization.getResourceType()), new Object[0]).body("resourceId", Matchers.equalTo((Object)authorization.getResourceId()), new Object[0]).body("removalTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_AUTH_REMOVAL_TIME), new Object[0]).body("rootProcessInstanceId", Matchers.equalTo((Object)authorization.getRootProcessInstanceId()), new Object[0]).when().get(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testGetNonExistingAuthorizationById() {
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().get(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testAuthenticationRestServiceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + SERVICE_PATH;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testAuthenticationRestServiceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + SERVICE_PATH;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_PATH, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testAuthorizationResourceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test/authorization/someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn(null);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void testAuthorizationResourceOptionsUnauthorized() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test/authorization/someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
    }

    @Test
    public void testAuthorizationResourceOptionsUpdateUnauthorized() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test/authorization/someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)((Authorization)authorizationQuery.singleResult())).thenReturn((Object)authorization);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
    }

    @Test
    public void testAuthorizationResourceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test/authorization/someAuthorizationId";
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(Mockito.anyString(), Mockito.anyList(), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class));
    }

    protected PermissionProvider getPermissionProvider() {
        return this.processEngineConfigurationMock.getPermissionProvider();
    }

    protected List<String> setupGroupQueryMock() {
        GroupQuery mockGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        List<Group> groupMocks = MockProvider.createMockGroups();
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.unlimitedList()).thenReturn(groupMocks);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groupMocks) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }
}

