/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String BATCH_RESOURCE_URL = "/rest-test/batch";
    protected static final String BATCH_QUERY_COUNT_URL = "/rest-test/batch/count";
    protected BatchQuery queryMock;

    @Before
    public void setUpBatchQueryMock() {
        List<Batch> mockedBatches = MockProvider.createMockBatches();
        this.queryMock = (BatchQuery)Mockito.mock(BatchQuery.class);
        Mockito.when((Object)this.queryMock.list()).thenReturn(mockedBatches);
        Mockito.when((Object)this.queryMock.count()).thenReturn((Object)mockedBatches.size());
        Mockito.when((Object)processEngine.getManagementService().createBatchQuery()).thenReturn((Object)this.queryMock);
    }

    @Test
    public void testNoParametersQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchListJson(response.asString());
    }

    @Test
    public void testUnknownQueryParameter() {
        Response response = (Response)RestAssured.given().queryParam("unknown", new Object[]{"unknown"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
        ((BatchQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).batchId(Mockito.anyString());
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).list();
        this.verifyBatchListJson(response.asString());
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"batchId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testBatchQueryByBatchId() {
        Response response = (Response)RestAssured.given().queryParam("batchId", new Object[]{"aBatchId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyBatchListJson(response.asString());
    }

    @Test
    public void testQueryActiveBatches() {
        Response response = (Response)RestAssured.given().queryParam("suspended", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).active();
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyBatchListJson(response.asString());
    }

    @Test
    public void testFullBatchQuery() {
        Response response = (Response)RestAssured.given().queryParams(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchListJson(response.asString());
    }

    @Test
    public void testQueryCount() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(BATCH_QUERY_COUNT_URL, new Object[0]);
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(BATCH_QUERY_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "desc", Response.Status.OK);
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "asc", Response.Status.OK);
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).desc();
    }

    private void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(BATCH_RESOURCE_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", "aBatchId");
        parameters.put("type", "aBatchType");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        parameters.put("suspended", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).batchId("aBatchId");
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).type("aBatchType");
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).withoutTenantId();
        ((BatchQuery)Mockito.verify((Object)this.queryMock)).suspended();
    }

    protected void verifyBatchListJson(String batchListJson) {
        List batches = (List)JsonPathUtil.from(batchListJson).get();
        Assert.assertEquals((String)"There should be one batch returned.", (long)1L, (long)batches.size());
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchListJson).getObject("[0]", BatchDto.class);
        String returnedStartTime = JsonPathUtil.from(batchListJson).getString("[0].startTime");
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)9L, (long)batch.getJobsCreated());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)batch.getCreateUserId());
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME, (Object)returnedStartTime);
        Assert.assertTrue((boolean)batch.isSuspended());
    }
}

