/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.batch.BatchStatisticsQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchStatisticsDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchRestServiceStatisticsTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String BATCH_RESOURCE_URL = "/rest-test/batch";
    protected static final String BATCH_STATISTICS_URL = "/rest-test/batch/statistics";
    protected static final String BATCH_STATISTICS_COUNT_URL = "/rest-test/batch/statistics/count";
    protected BatchStatisticsQuery queryMock;
    protected List<BatchStatistics> mockBatchStatisticsList;

    @Before
    public void setUpBatchStatisticsMock() {
        this.mockBatchStatisticsList = MockProvider.createMockBatchStatisticsList();
        this.queryMock = (BatchStatisticsQuery)Mockito.mock(BatchStatisticsQuery.class);
        Mockito.when((Object)this.queryMock.list()).thenReturn(this.mockBatchStatisticsList);
        Mockito.when((Object)this.queryMock.count()).thenReturn((Object)this.mockBatchStatisticsList.size());
        Mockito.when((Object)processEngine.getManagementService().createBatchStatisticsQuery()).thenReturn((Object)this.queryMock);
    }

    @Test
    public void testQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testUnknownQueryParameter() {
        Response response = (Response)RestAssured.given().queryParam("unknown", new Object[]{"unknown"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).batchId(Mockito.anyString());
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testBatchQueryByBatchId() {
        Response response = (Response)RestAssured.given().queryParam("batchId", new Object[]{"aBatchId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testQueryActiveBatches() {
        Response response = (Response)RestAssured.given().queryParam("suspended", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).active();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testFullBatchQuery() {
        Response response = (Response)RestAssured.given().queryParams(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testQueryCount() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)1), new Object[0]).when().get(BATCH_STATISTICS_COUNT_URL, new Object[0]);
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)1), new Object[0]).when().get(BATCH_STATISTICS_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testQueryPagination() {
        Mockito.when((Object)this.queryMock.listPage(1, 2)).thenReturn(this.mockBatchStatisticsList);
        Response response = (Response)RestAssured.given().queryParam("firstResult", new Object[]{1}).queryParam("maxResults", new Object[]{2}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).listPage(1, 2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyBatchStatisticsListJson(response.asString());
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "desc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "asc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("startTime", "asc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderByStartTime();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("startTime", "desc", Response.Status.OK);
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).orderByStartTime();
        ((BatchStatisticsQuery)inOrder.verify((Object)this.queryMock)).desc();
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"batchId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(BATCH_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(BATCH_STATISTICS_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", "aBatchId");
        parameters.put("type", "aBatchType");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        parameters.put("suspended", true);
        parameters.put("createdBy", "userId");
        parameters.put("startedBefore", MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME);
        parameters.put("startedAfter", MockProvider.EXAMPLE_HISTORIC_BATCH_END_TIME);
        parameters.put("withFailures", true);
        parameters.put("withoutFailures", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).batchId("aBatchId");
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).type("aBatchType");
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).withoutTenantId();
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).suspended();
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).createdBy("userId");
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).startedBefore(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME));
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).startedAfter(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_END_TIME));
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).withFailures();
        ((BatchStatisticsQuery)Mockito.verify((Object)this.queryMock)).withoutFailures();
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(BATCH_STATISTICS_URL, new Object[0]);
    }

    protected void verifyBatchStatisticsListJson(String batchStatisticsListJson) {
        List batches = (List)JsonPathUtil.from(batchStatisticsListJson).get();
        Assert.assertEquals((String)"There should be one batch statistics returned.", (long)1L, (long)batches.size());
        BatchStatisticsDto batchStatistics = (BatchStatisticsDto)JsonPathUtil.from(batchStatisticsListJson).getObject("[0]", BatchStatisticsDto.class);
        String returnedStartTime = JsonPathUtil.from(batchStatisticsListJson).getString("[0].startTime");
        Assert.assertNotNull((String)"The returned batch statistics should not be null.", (Object)batchStatistics);
        Assert.assertEquals((Object)"aBatchId", (Object)batchStatistics.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batchStatistics.getType());
        Assert.assertEquals((long)10L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)9L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)11L, (long)batchStatistics.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batchStatistics.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batchStatistics.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batchStatistics.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batchStatistics.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batchStatistics.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)batchStatistics.getCreateUserId());
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME, (Object)returnedStartTime);
        Assert.assertEquals((long)21L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)22L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)23L, (long)batchStatistics.getFailedJobs());
        Assert.assertTrue((boolean)batchStatistics.isSuspended());
    }
}

