/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class DeploymentRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DEPLOYMENT_QUERY_URL = "/rest-test/deployment";
    protected static final String DEPLOYMENT_COUNT_QUERY_URL = "/rest-test/deployment/count";
    private DeploymentQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockDeploymentQuery(MockProvider.createMockDeployments());
    }

    private DeploymentQuery setUpMockDeploymentQuery(List<Deployment> mockedDeployments) {
        DeploymentQuery sampleDeploymentQuery = (DeploymentQuery)Mockito.mock(DeploymentQuery.class);
        Mockito.when((Object)sampleDeploymentQuery.list()).thenReturn(mockedDeployments);
        Mockito.when((Object)sampleDeploymentQuery.count()).thenReturn((Object)mockedDeployments.size());
        Mockito.when((Object)processEngine.getRepositoryService().createDeploymentQuery()).thenReturn((Object)sampleDeploymentQuery);
        return sampleDeploymentQuery;
    }

    @Test
    public void testEmptyQuery() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifyFailingSorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST, InvalidRequestException.class.getSimpleName(), "Cannot set query parameter 'sortBy' to value 'anInvalidSortByOption'");
        this.executeAndVerifyFailingSorting("name", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST, InvalidRequestException.class.getSimpleName(), "Cannot set query parameter 'sortOrder' to value 'anInvalidSortOrderOption'");
    }

    protected void executeAndVerifySuccessfulSorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    protected void executeAndVerifyFailingSorting(String sortBy, String sortOrder, Response.Status expectedStatus, String expectedErrorType, String expectedErrorMessage) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)expectedErrorType), new Object[0]).body("message", Matchers.equalTo((Object)expectedErrorMessage), new Object[0]).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"name"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testDeploymentRetrieval() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        String queryKey = "Name";
        Response response = (Response)RestAssured.given().queryParam("nameLike", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).deploymentNameLike(queryKey);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List deployments = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one deployment returned.", (long)1L, (long)deployments.size());
        Assert.assertNotNull((String)"There should be one deployment returned", deployments.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        String returnedSource = JsonPath.from((String)content).getString("[0].source");
        String returnedDeploymentTime = JsonPath.from((String)content).getString("[0].deploymentTime");
        Assert.assertEquals((Object)"aDeploymentId", (Object)returnedId);
        Assert.assertEquals((Object)"aName", (Object)returnedName);
        Assert.assertEquals((Object)"aDeploymentSource", (Object)returnedSource);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_DEPLOYMENT_TIME, (Object)returnedDeploymentTime);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentName(queryParameters.get("name"));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentNameLike(queryParameters.get("nameLike"));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("id"));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentSource(queryParameters.get("source"));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testWithoutSourceParameter() {
        RestAssured.given().queryParam("withoutSource", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentSource(null);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testSourceAndWithoutSource() {
        RestAssured.given().queryParam("withoutSource", new Object[]{true}).queryParam("source", new Object[]{"source"}).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"The query parameters \"withoutSource\" and \"source\" cannot be used in combination."), new Object[0]).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testDeploymentBefore() {
        RestAssured.given().queryParam("before", new Object[]{MockProvider.EXAMPLE_DEPLOYMENT_TIME_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentBefore((Date)Mockito.any(Date.class));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDeploymentAfter() {
        RestAssured.given().queryParam("after", new Object[]{MockProvider.EXAMPLE_DEPLOYMENT_TIME_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).deploymentAfter((Date)Mockito.any(Date.class));
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDeploymentTenantIdList() {
        List<Deployment> deployments = Arrays.asList(MockProvider.createMockDeployment("aTenantId"), MockProvider.createMockDeployment("anotherTenantId"));
        this.mockedQuery = this.setUpMockDeploymentQuery(deployments);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testDeploymentWithoutTenantId() {
        Deployment mockDeployment = MockProvider.createMockDeployment(null);
        this.mockedQuery = this.setUpMockDeploymentQuery(Collections.singletonList(mockDeployment));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testDeploymentTenantIdIncludeDefinitionsWithoutTenantid() {
        List<Deployment> mockDeployments = Arrays.asList(MockProvider.createMockDeployment(null), MockProvider.createMockDeployment("aTenantId"));
        this.mockedQuery = this.setUpMockDeploymentQuery(mockDeployments);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeDeploymentsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).includeDeploymentsWithoutTenantId();
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", "depId");
        parameters.put("name", "name");
        parameters.put("nameLike", "nameLike");
        parameters.put("source", "source");
        return parameters;
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("id", "asc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("id", "desc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("deploymentTime", "asc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentTime();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("deploymentTime", "desc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentTime();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("name", "asc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentName();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("name", "desc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentName();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("tenantId", "asc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySuccessfulSorting("tenantId", "desc", Response.Status.OK);
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DeploymentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(DEPLOYMENT_COUNT_QUERY_URL, new Object[0]);
        ((DeploymentQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }
}

