/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class ExceptionHandlerTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    private static final String EXCEPTION_RESOURCE_URL = "/rest-test/unannotated";
    private static final String GENERAL_EXCEPTION_URL = "/rest-test/unannotated/exception";
    private static final String PROCESS_ENGINE_EXCEPTION_URL = "/rest-test/unannotated/processEngineException";
    private static final String REST_EXCEPTION_URL = "/rest-test/unannotated/restException";
    private static final String AUTH_EXCEPTION_URL = "/rest-test/unannotated/authorizationException";
    private static final String AUTH_EXCEPTION_MULTIPLE_URL = "/rest-test/unannotated/authorizationExceptionMultiple";
    private static final String STACK_OVERFLOW_ERROR_URL = "/rest-test/unannotated/stackOverflowError";

    @Test
    public void testGeneralExceptionHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)Exception.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).body("code", Matchers.nullValue(), new Object[0]).when().get(GENERAL_EXCEPTION_URL, new Object[0]);
    }

    @Test
    public void testRestExceptionHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).body("code", Matchers.nullValue(), new Object[0]).when().get(REST_EXCEPTION_URL, new Object[0]);
    }

    @Test
    public void testProcessEngineExceptionHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).body("code", Matchers.equalTo((Object)0), new Object[0]).when().get(PROCESS_ENGINE_EXCEPTION_URL, new Object[0]);
    }

    @Test
    public void testAuthorizationExceptionHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"The user with id 'someUser' does not have 'somePermission' permission on resource 'someResourceId' of type 'someResourceName'."), new Object[0]).body("code", Matchers.equalTo((Object)0), new Object[0]).body("userId", Matchers.equalTo((Object)"someUser"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"someResourceName"), new Object[0]).body("resourceId", Matchers.equalTo((Object)"someResourceId"), new Object[0]).body("permissionName", Matchers.equalTo((Object)"somePermission"), new Object[0]).body("missingAuthorizations.resourceName", Matchers.hasItems((Object[])new String[]{"someResourceName"}), new Object[0]).body("missingAuthorizations.resourceId", Matchers.hasItems((Object[])new String[]{"someResourceId"}), new Object[0]).body("missingAuthorizations.permissionName", Matchers.hasItems((Object[])new String[]{"somePermission"}), new Object[0]).when().get(AUTH_EXCEPTION_URL, new Object[0]);
    }

    @Test
    public void testAuthorizationExceptionWithMultipleMissingAuthorizationsHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("code", Matchers.equalTo((Object)0), new Object[0]).body("message", Matchers.equalTo((Object)"The user with id 'someUser' does not have one of the following permissions: 'somePermission1' permission on resource 'someResourceId1' of type 'someResourceName1' or 'somePermission2' permission on resource 'someResourceId2' of type 'someResourceName2'"), new Object[0]).body("userId", Matchers.equalTo((Object)"someUser"), new Object[0]).body("resourceName", Matchers.equalTo(null), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("permissionName", Matchers.equalTo(null), new Object[0]).body("missingAuthorizations.resourceName", Matchers.hasItems((Object[])new String[]{"someResourceName1", "someResourceName2"}), new Object[0]).body("missingAuthorizations.resourceId", Matchers.hasItems((Object[])new String[]{"someResourceId1", "someResourceId2"}), new Object[0]).body("missingAuthorizations.permissionName", Matchers.hasItems((Object[])new String[]{"somePermission1", "somePermission2"}), new Object[0]).when().get(AUTH_EXCEPTION_MULTIPLE_URL, new Object[0]);
    }

    @Test
    public void testThrowableHandler() {
        RestAssured.given().header(ACCEPT_WILDCARD_HEADER).expect().contentType(ContentType.JSON).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)StackOverflowError.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Stack overflow"), new Object[0]).body("code", Matchers.nullValue(), new Object[0]).when().get(STACK_OVERFLOW_ERROR_URL, new Object[0]);
    }
}

