/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;

public class ProcessInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_INSTANCE_QUERY_URL = "/rest-test/process-instance";
    protected static final String PROCESS_INSTANCE_COUNT_QUERY_URL = "/rest-test/process-instance/count";
    private static final String TEST_VAR_NAME = "varName";
    private static final String TEST_VAR_VALUE = "varValue";
    protected ProcessInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockInstanceQuery(this.createMockInstanceList());
    }

    private ProcessInstanceQuery setUpMockInstanceQuery(List<ProcessInstance> mockedInstances) {
        ProcessInstanceQuery sampleInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)sampleInstanceQuery.list()).thenReturn(mockedInstances);
        Mockito.when((Object)sampleInstanceQuery.count()).thenReturn((Object)mockedInstances.size());
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        return sampleInstanceQuery;
    }

    private List<ProcessInstance> createMockInstanceList() {
        ArrayList<ProcessInstance> mocks = new ArrayList<ProcessInstance>();
        mocks.add(MockProvider.createMockInstance());
        return mocks;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidVariableRequests() {
        String invalidComparator = "anInvalidComparator";
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        Object queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"definitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInstanceRetrieval() {
        String queryKey = "key";
        Response response = (Response)RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).processDefinitionKey(queryKey);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process definition returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"There should be one process definition returned", instances.get(0));
        String returnedInstanceId = JsonPath.from((String)content).getString("[0].id");
        Boolean returnedIsEnded = JsonPath.from((String)content).getBoolean("[0].ended");
        String returnedDefinitionId = JsonPath.from((String)content).getString("[0].definitionId");
        String returnedBusinessKey = JsonPath.from((String)content).getString("[0].businessKey");
        Boolean returnedIsSuspended = JsonPath.from((String)content).getBoolean("[0].suspended");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedInstanceId);
        Assert.assertEquals((Object)false, (Object)returnedIsEnded);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedBusinessKey);
        Assert.assertEquals((Object)false, (Object)returnedIsSuspended);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testIncompleteProcessInstance() {
        this.setUpMockInstanceQuery(this.createIncompleteMockInstances());
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        String content = response.asString();
        String returnedBusinessKey = JsonPath.from((String)content).getString("[0].businessKey");
        Assert.assertNull((String)"Should be null, as it is also null in the original process instance on the server.", (Object)returnedBusinessKey);
    }

    private List<ProcessInstance> createIncompleteMockInstances() {
        ArrayList<ProcessInstance> mocks = new ArrayList<ProcessInstance>();
        ProcessInstance mockInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)mockInstance.getId()).thenReturn((Object)"aProcInstId");
        mocks.add(mockInstance);
        return mocks;
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testAdditionalParametersExcludingVariables() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(queryParameters.get("caseInstanceId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(queryParameters.get("businessKey"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyLike(queryParameters.get("businessKeyLike"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(queryParameters.get("processDefinitionKey"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(queryParameters.get("processDefinitionId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("deploymentId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId(queryParameters.get("superProcessInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId(queryParameters.get("subProcessInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId(queryParameters.get("superCaseInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId(queryParameters.get("subCaseInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(queryParameters.get("incidentId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(queryParameters.get("incidentMessage"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessageLike(queryParameters.get("incidentMessageLike"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(queryParameters.get("incidentType"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("businessKey", "aBusinessKey");
        parameters.put("businessKeyLike", "aKeyLike");
        parameters.put("processDefinitionKey", "aProcDefKey");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("deploymentId", "deploymentId");
        parameters.put("superProcessInstance", "aSuperProcInstId");
        parameters.put("subProcessInstance", "aSubProcInstId");
        parameters.put("superCaseInstance", "aSuperCaseInstId");
        parameters.put("subCaseInstance", "aSubCaseInstId");
        parameters.put("suspended", "true");
        parameters.put("active", "true");
        parameters.put("incidentId", "incId");
        parameters.put("incidentMessage", "incMessage");
        parameters.put("incidentMessageLike", "incMessageLike");
        parameters.put("incidentType", "incType");
        parameters.put("caseInstanceId", "aCaseInstanceId");
        return parameters;
    }

    @Test
    public void testVariableValueEquals() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThan() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThanEquals() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThan() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThanEquals() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLike() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
    }

    @Test
    public void testVariableValueNotEquals() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableNamesEqualsIgnoreCase() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValuesEqualsIgnoreCase() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCase() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCase() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValuesLikeIgnoreCase() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
    }

    @Test
    public void testVariableValueEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueGreaterThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "gt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueGreaterThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "gteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueLessThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "lt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueLessThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "lteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueLikeAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(TEST_VAR_NAME, TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValueNotEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValuesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableValuesLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(TEST_VAR_NAME, TEST_VAR_VALUE);
    }

    @Test
    public void testVariableNamesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", TEST_VAR_NAME);
        variableJson.put("value", TEST_VAR_VALUE);
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(TEST_VAR_NAME, (Object)TEST_VAR_VALUE);
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = TEST_VAR_NAME;
        String variableValue1 = TEST_VAR_VALUE;
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = TEST_VAR_NAME;
        String variableValue = TEST_VAR_VALUE;
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)Mockito.eq((Object)anotherVariableName), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testDateVariableParameter() {
        String variableName = TEST_VAR_NAME;
        String variableValue = DateTimeUtils.withTimezone("2014-06-16T10:00:00");
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        Date date = DateTimeUtil.parseDate((String)variableValue);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)date);
    }

    @Test
    public void testDateVariableParameterAsPost() {
        String variableName = TEST_VAR_NAME;
        String variableValue = DateTimeUtils.withTimezone("2014-06-16T10:00:00");
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        Date date = DateTimeUtil.parseDate((String)variableValue);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)date);
    }

    @Test
    public void testCompletePostParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(queryParameters.get("caseInstanceId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(queryParameters.get("businessKey"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyLike(queryParameters.get("businessKeyLike"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(queryParameters.get("processDefinitionKey"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(queryParameters.get("processDefinitionId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("deploymentId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId(queryParameters.get("superProcessInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId(queryParameters.get("subProcessInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId(queryParameters.get("superCaseInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId(queryParameters.get("subCaseInstance"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(queryParameters.get("incidentId"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(queryParameters.get("incidentMessage"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessageLike(queryParameters.get("incidentMessageLike"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(queryParameters.get("incidentType"));
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockInstanceQuery(this.createMockProcessInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)instances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        this.mockedQuery = this.setUpMockInstanceQuery(Arrays.asList(MockProvider.createMockInstance(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockInstanceQuery(this.createMockProcessInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        this.mockedQuery = this.setUpMockInstanceQuery(Arrays.asList(MockProvider.createMockInstance(null)));
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    private List<ProcessInstance> createMockProcessInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockInstance("aTenantId"), MockProvider.createMockInstance("anotherTenantId"));
    }

    @Test
    public void testActivityIdListParameter() {
        RestAssured.given().queryParam("activityIdIn", new Object[]{"anActivity,anotherActivity"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{"anActivity", "anotherActivity"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testActivityIdListPostParameter() {
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("activityIdIn", "anActivity,anotherActivity".split(","));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{"anActivity", "anotherActivity"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionKey", "desc", Response.Status.OK);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "asc", Response.Status.OK);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("businessKey", "asc", Response.Status.OK);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByBusinessKey();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("definitionKey").desc().orderBy("definitionId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((ProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(PROCESS_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(PROCESS_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testInstanceRetrievalByList() {
        ArrayList<ProcessInstance> mockProcessInstanceList = new ArrayList<ProcessInstance>();
        mockProcessInstanceList.add(MockProvider.createMockInstance());
        mockProcessInstanceList.add(MockProvider.createAnotherMockInstance());
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        Mockito.when((Object)instanceQuery.list()).thenReturn(mockProcessInstanceList);
        Response response = (Response)RestAssured.given().queryParam("processInstanceIds", new Object[]{"aProcInstId,anotherId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{instanceQuery});
        Set<String> expectedSet = MockProvider.createMockSetFromList("aProcInstId,anotherId");
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).processInstanceIds(expectedSet);
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two process definitions returned.", (long)2L, (long)instances.size());
        String returnedInstanceId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedInstanceId2 = JsonPath.from((String)content).getString("[1].id");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedInstanceId1);
        Assert.assertEquals((Object)"anotherId", (Object)returnedInstanceId2);
    }

    @Test
    public void testInstanceRetrievalByListAsPost() {
        ArrayList<ProcessInstance> mockProcessInstanceList = new ArrayList<ProcessInstance>();
        mockProcessInstanceList.add(MockProvider.createMockInstance());
        mockProcessInstanceList.add(MockProvider.createAnotherMockInstance());
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        Mockito.when((Object)instanceQuery.list()).thenReturn(mockProcessInstanceList);
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        Set<String> processInstanceIds = MockProvider.createMockSetFromList("aProcInstId,anotherId");
        params.put("processInstanceIds", processInstanceIds);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{instanceQuery});
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).processInstanceIds(processInstanceIds);
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two process definitions returned.", (long)2L, (long)instances.size());
        String returnedInstanceId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedInstanceId2 = JsonPath.from((String)content).getString("[1].id");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedInstanceId1);
        Assert.assertEquals((Object)"anotherId", (Object)returnedInstanceId2);
    }

    @Test
    public void testInstanceRetrievalByListWithDuplicate() {
        ArrayList<ProcessInstance> mockProcessInstanceList = new ArrayList<ProcessInstance>();
        mockProcessInstanceList.add(MockProvider.createMockInstance());
        mockProcessInstanceList.add(MockProvider.createAnotherMockInstance());
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)instanceQuery.list()).thenReturn(mockProcessInstanceList);
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        Response response = (Response)RestAssured.given().queryParam("processInstanceIds", new Object[]{"aProcInstId,anotherId,aProcInstId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{instanceQuery});
        Set<String> expectedSet = MockProvider.createMockSetFromList("aProcInstId,anotherId");
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).processInstanceIds(expectedSet);
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two process definitions returned.", (long)2L, (long)instances.size());
        String returnedInstanceId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedInstanceId2 = JsonPath.from((String)content).getString("[1].id");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedInstanceId1);
        Assert.assertEquals((Object)"anotherId", (Object)returnedInstanceId2);
    }

    @Test
    public void testInstanceRetrievalByListWithDuplicateAsPost() {
        ArrayList<ProcessInstance> mockProcessInstanceList = new ArrayList<ProcessInstance>();
        mockProcessInstanceList.add(MockProvider.createMockInstance());
        mockProcessInstanceList.add(MockProvider.createAnotherMockInstance());
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)instanceQuery.list()).thenReturn(mockProcessInstanceList);
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        Set<String> processInstanceIds = MockProvider.createMockSetFromList("aProcInstId,anotherId");
        params.put("processInstanceIds", processInstanceIds);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{instanceQuery});
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).processInstanceIds(processInstanceIds);
        ((ProcessInstanceQuery)inOrder.verify((Object)instanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two process definitions returned.", (long)2L, (long)instances.size());
        String returnedInstanceId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedInstanceId2 = JsonPath.from((String)content).getString("[1].id");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedInstanceId1);
        Assert.assertEquals((Object)"anotherId", (Object)returnedInstanceId2);
    }

    @Test
    public void testInstanceRetrievalByListWithEmpty() {
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)instanceQuery.list()).thenReturn(null);
        String expectedExceptionMessage = "Set of process instance ids is empty";
        ((ProcessInstanceQuery)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedExceptionMessage)}).when((Object)instanceQuery)).processInstanceIds(Mockito.anySet());
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        String emptyList = "";
        RestAssured.given().queryParam("processInstanceIds", new Object[]{emptyList}).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedExceptionMessage), new Object[0]).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInstanceRetrievalByListWithEmptyAsPost() {
        ProcessInstanceQuery instanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)instanceQuery.list()).thenReturn(null);
        String expectedExceptionMessage = "Set of process instance ids is empty";
        ((ProcessInstanceQuery)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedExceptionMessage)}).when((Object)instanceQuery)).processInstanceIds(Mockito.anySet());
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)instanceQuery);
        HashMap params = new HashMap();
        params.put("processInstanceIds", new HashSet());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedExceptionMessage), new Object[0]).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testQueryRootProcessInstances() {
        RestAssured.given().queryParam("rootProcessInstances", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootProcessInstances();
    }

    @Test
    public void testQueryRootProcessInstancesAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("rootProcessInstances", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootProcessInstances();
    }

    @Test
    public void testQueryLeafProcessInstances() {
        RestAssured.given().queryParam("leafProcessInstances", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).leafProcessInstances();
    }

    @Test
    public void testQueryLeafProcessInstancesAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("leafProcessInstances", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).leafProcessInstances();
    }

    @Test
    public void testQueryProcessDefinitionWithoutTenantId() {
        RestAssured.given().queryParam("processDefinitionWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionWithoutTenantId();
    }

    @Test
    public void testQueryProcessDefinitionWithoutTenantIdAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionWithoutTenantId();
    }

    @Test
    public void testQueryProcessInstanceWithIncident() {
        RestAssured.given().queryParam("withIncident", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withIncident();
    }

    @Test
    public void testQueryProcessInstanceWithIncidentAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("withIncident", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withIncident();
    }

    @Test
    public void testProcessDefinitionKeyInParameter() {
        RestAssured.given().queryParam("processDefinitionKeyIn", new Object[]{"aKey,anotherProcessDefinitionKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyIn(new String[]{"aKey", "anotherProcessDefinitionKey"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessDefinitionKeyInPostParameter() {
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("processDefinitionKeyIn", "aKey,anotherProcessDefinitionKey".split(","));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyIn(new String[]{"aKey", "anotherProcessDefinitionKey"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessDefinitionKeyNotInParameter() {
        RestAssured.given().queryParam("processDefinitionKeyNotIn", new Object[]{"aKey,anotherProcessDefinitionKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyNotIn(new String[]{"aKey", "anotherProcessDefinitionKey"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessDefinitionKeyNotInPostParameter() {
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("processDefinitionKeyNotIn", "aKey,anotherProcessDefinitionKey".split(","));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyNotIn(new String[]{"aKey", "anotherProcessDefinitionKey"});
        ((ProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testOrQuery() {
        ProcessInstanceQuery mockedQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQueryImpl.class);
        Mockito.when((Object)processEngine.getRuntimeService().createProcessInstanceQuery()).thenReturn((Object)mockedQuery);
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        ProcessInstanceQueryDto orQuery = new ProcessInstanceQueryDto();
        orQuery.setProcessDefinitionId("aProcDefId");
        orQuery.setBusinessKey("aKey");
        processInstanceQueryDto.setOrQueries(Collections.singletonList(orQuery));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header(ACCEPT_JSON_HEADER).body((Object)processInstanceQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_QUERY_URL, new Object[0]);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessInstanceQueryImpl.class);
        ((ProcessInstanceQueryImpl)Mockito.verify((Object)((ProcessInstanceQueryImpl)mockedQuery))).addOrQuery((ProcessInstanceQueryImpl)argument.capture());
        Assertions.assertThat((String)((ProcessInstanceQueryImpl)argument.getValue()).getProcessDefinitionId()).isEqualTo((Object)"aProcDefId");
        Assertions.assertThat((String)((ProcessInstanceQueryImpl)argument.getValue()).getBusinessKey()).isEqualTo((Object)"aKey");
    }
}

