/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.telemetry.ApplicationServer;
import org.camunda.bpm.engine.telemetry.Database;
import org.camunda.bpm.engine.telemetry.Internals;
import org.camunda.bpm.engine.telemetry.Jdk;
import org.camunda.bpm.engine.telemetry.Product;
import org.camunda.bpm.engine.telemetry.TelemetryData;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TelemetryRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TELEMETRY_URL = "/rest-test/telemetry";
    protected static final String TELEMETRY_CONFIG_URL = "/rest-test/telemetry/configuration";
    protected static final String TELEMETRY_DATA_URL = "/rest-test/telemetry/data";
    protected ManagementService managementServiceMock;

    @Before
    public void setupMocks() {
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
    }

    @Test
    public void shouldDisableTelemetry() {
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", false);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).toggleTelemetry(false);
    }

    @Test
    public void shouldEnableTelemetry() {
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).toggleTelemetry(true);
    }

    @Test
    public void shouldThrowAuthorizationExceptionOnEnablingTelemetry() {
        String message = "Required admin authenticated group or user.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.managementServiceMock)).toggleTelemetry(ArgumentMatchers.anyBoolean());
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
    }

    @Test
    public void shouldFetchEnabledTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn((Object)true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo((Object)true), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldFetchDisabledTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn((Object)false);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo((Object)false), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldFetchEmptyTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn(null);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo(null), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldThrowAuthorizationExceptionOnFetchingTelemetryConfig() {
        String message = "Required admin authenticated group or user.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.managementServiceMock)).isTelemetryEnabled();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldGetTelemetryData() throws JsonProcessingException {
        Mockito.when((Object)this.managementServiceMock.getTelemetryData()).thenReturn((Object)MockProvider.EXAMPLE_TELEMETRY_DATA);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("installation", Matchers.equalTo((Object)"8343cc7a-8ad1-42d4-97d2-43452c0bdfa3"), new Object[0]).body("product.name", Matchers.equalTo((Object)"Camunda BPM Runtime"), new Object[0]).body("product.version", Matchers.equalTo((Object)"7.14.0"), new Object[0]).body("product.edition", Matchers.equalTo((Object)"enterprise"), new Object[0]).body("product.internals.database.vendor", Matchers.equalTo((Object)"h2"), new Object[0]).body("product.internals.database.version", Matchers.equalTo((Object)"1.4.190 (2015-10-11)"), new Object[0]).body("product.internals.commands.FetchExternalTasksCmd.count", Matchers.equalTo((Object)100), new Object[0]).body("product.internals.commands.StartProcessInstanceCmd.count", Matchers.equalTo((Object)40), new Object[0]).body("product.internals.metrics.process-instances.count", Matchers.equalTo((Object)936), new Object[0]).body("product.internals.metrics.flow-node-instances.count", Matchers.equalTo((Object)6125), new Object[0]).body("product.internals.metrics.executed-decision-elements.count", Matchers.equalTo((Object)732), new Object[0]).body("product.internals.metrics.decision-instances.count", Matchers.equalTo((Object)140), new Object[0]).body("product.internals.webapps[0]", Matchers.equalTo((Object)"cockpit"), new Object[0]).body("product.internals.jdk.vendor", Matchers.equalTo((Object)"Oracle Corporation"), new Object[0]).body("product.internals.jdk.version", Matchers.equalTo((Object)"14.0.2"), new Object[0]).body("product.internals.application-server.vendor", Matchers.equalTo((Object)"Wildfly"), new Object[0]).body("product.internals.application-server.version", Matchers.equalTo((Object)"WildFly Full 19.0.0.Final (WildFly Core 11.0.0.Final) - 2.0.30.Final"), new Object[0]).body("product.internals.license-key.customer", Matchers.equalTo((Object)"customer name"), new Object[0]).body("product.internals.license-key.type", Matchers.equalTo((Object)"UNIFIED"), new Object[0]).body("product.internals.license-key.features.camundaBPM", Matchers.equalTo((Object)"true"), new Object[0]).body("product.internals.license-key.raw", Matchers.equalTo((Object)"customer=customer name;expiryDate=2022-09-30;camundaBPM=true;optimize=false;cawemo=false"), new Object[0]).body("product.internals.license-key.unlimited", Matchers.equalTo((Object)false), new Object[0]).body("product.internals.license-key.valid-until", Matchers.equalTo((Object)"2022-09-30"), new Object[0]).body("product.internals.camunda-integration[0]", Matchers.equalTo((Object)"spring-boot"), new Object[0]).body("product.internals.data-collection-start-date", Matchers.equalTo((Object)MockProvider.EXAMPLE_TELEMETRY_DATA_COLLECTION_START_DATE), new Object[0]).when().get(TELEMETRY_DATA_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).getTelemetryData();
    }

    @Test
    public void shouldGetMinimalTelemetryData() {
        TelemetryData telemetryData = (TelemetryData)Mockito.mock(TelemetryData.class);
        Mockito.when((Object)telemetryData.getInstallation()).thenReturn((Object)"8343cc7a-8ad1-42d4-97d2-43452c0bdfa3");
        Product product = (Product)Mockito.mock(Product.class);
        Mockito.when((Object)product.getName()).thenReturn((Object)"Camunda BPM Runtime");
        Mockito.when((Object)product.getVersion()).thenReturn((Object)"7.14.0");
        Mockito.when((Object)product.getEdition()).thenReturn((Object)"enterprise");
        Mockito.when((Object)telemetryData.getProduct()).thenReturn((Object)product);
        Internals internals = (Internals)Mockito.mock(Internals.class);
        Mockito.when((Object)product.getInternals()).thenReturn((Object)internals);
        Mockito.when((Object)internals.getApplicationServer()).thenReturn((Object)((ApplicationServer)Mockito.mock(ApplicationServer.class)));
        Mockito.when((Object)internals.getCamundaIntegration()).thenReturn(new HashSet());
        Mockito.when((Object)internals.getCommands()).thenReturn(new HashMap());
        Mockito.when((Object)internals.getDatabase()).thenReturn((Object)((Database)Mockito.mock(Database.class)));
        Mockito.when((Object)internals.getJdk()).thenReturn((Object)((Jdk)Mockito.mock(Jdk.class)));
        Mockito.when((Object)internals.getMetrics()).thenReturn(new HashMap());
        Mockito.when((Object)internals.getWebapps()).thenReturn(new HashSet());
        Mockito.when((Object)this.managementServiceMock.getTelemetryData()).thenReturn((Object)telemetryData);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("installation", Matchers.equalTo((Object)"8343cc7a-8ad1-42d4-97d2-43452c0bdfa3"), new Object[0]).body("product.name", Matchers.equalTo((Object)"Camunda BPM Runtime"), new Object[0]).body("product.version", Matchers.equalTo((Object)"7.14.0"), new Object[0]).body("product.edition", Matchers.equalTo((Object)"enterprise"), new Object[0]).when().get(TELEMETRY_DATA_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).getTelemetryData();
    }
}

