/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.identity.UserCredentialsDto;
import org.camunda.bpm.engine.rest.dto.identity.UserDto;
import org.camunda.bpm.engine.rest.dto.identity.UserProfileDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UserRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.rest.exception"});
    protected static final String SERVICE_URL = "/rest-test/user";
    protected static final String USER_URL = "/rest-test/user/{id}";
    protected static final String USER_CREATE_URL = "/rest-test/user/create";
    protected static final String USER_PROFILE_URL = "/rest-test/user/{id}/profile";
    protected static final String USER_CREDENTIALS_URL = "/rest-test/user/{id}/credentials";
    protected static final String USER_UNLOCK = "/rest-test/user/{id}/unlock";
    protected IdentityService identityServiceMock;
    protected AuthorizationService authorizationServiceMock;
    protected ProcessEngineConfiguration processEngineConfigurationMock;

    @Before
    public void setupUserData() {
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityService.class);
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        this.processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
    }

    @Test
    public void testGetSingleUserProfile() {
        User sampleUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)sampleUser);
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"userId"), new Object[0]).body("firstName", Matchers.equalTo((Object)"firstName"), new Object[0]).body("lastName", Matchers.equalTo((Object)"lastName"), new Object[0]).body("email", Matchers.equalTo((Object)"test@example.org"), new Object[0]).when().get(USER_PROFILE_URL, new Object[0]);
    }

    @Test
    public void testUserRestServiceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + SERVICE_URL;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testUserRestServiceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + SERVICE_URL;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testUserResourceOptionsUnauthenticated() {
        String fullUserUrl = "http://localhost:" + PORT + "/rest-test/user/userId";
        User sampleUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)sampleUser);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn(null);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullUserUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(USER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void testUserResourceOptionsUnauthorized() {
        String fullUserUrl = "http://localhost:" + PORT + "/rest-test/user/userId";
        User sampleUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)sampleUser);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.USER, "userId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.USER, "userId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(USER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.USER, "userId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.USER, "userId");
    }

    @Test
    public void testUserResourceOptionsDeleteAuthorized() {
        String fullUserUrl = "http://localhost:" + PORT + "/rest-test/user/userId";
        User sampleUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)sampleUser);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.USER, "userId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.USER, "userId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullUserUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(USER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.USER, "userId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.USER, "userId");
    }

    @Test
    public void testUserResourceOptionsWithAuthorizationDisabled() {
        String fullUserUrl = "http://localhost:" + PORT + "/rest-test/user/userId";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullUserUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullUserUrl + "/profile")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(USER_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testGetNonExistingUserProfile() {
        String exceptionMessage = "User with id aNonExistingUser does not exist";
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId(Mockito.anyString())).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingUser").then().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(USER_PROFILE_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testDeleteUser() {
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(USER_URL, new Object[0]);
    }

    @Test
    public void testDeleteNonExistingUser() {
        RestAssured.given().pathParam("id", (Object)"non-existing").then().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(USER_URL, new Object[0]);
    }

    @Test
    public void testDeleteUserThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).deleteUser("userId");
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(USER_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    @Test
    public void testCreateNewUserWithCredentials() {
        User newUser = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.newUser("userId")).thenReturn((Object)newUser);
        UserDto userDto = UserDto.fromUser((User)newUser, (boolean)true);
        RestAssured.given().body((Object)userDto).contentType(ContentType.JSON).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(USER_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newUser("userId");
        ((User)Mockito.verify((Object)newUser)).setFirstName("firstName");
        ((User)Mockito.verify((Object)newUser)).setLastName("lastName");
        ((User)Mockito.verify((Object)newUser)).setEmail("test@example.org");
        ((User)Mockito.verify((Object)newUser)).setPassword("s3cret");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(newUser);
    }

    @Test
    public void testCreateNewUserWithoutCredentials() {
        User newUser = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.newUser("userId")).thenReturn((Object)newUser);
        UserDto userDto = UserDto.fromUser((User)newUser, (boolean)false);
        RestAssured.given().body((Object)userDto).contentType(ContentType.JSON).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(USER_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newUser("userId");
        ((User)Mockito.verify((Object)newUser)).setFirstName("firstName");
        ((User)Mockito.verify((Object)newUser)).setLastName("lastName");
        ((User)Mockito.verify((Object)newUser)).setEmail("test@example.org");
        ((User)Mockito.verify((Object)newUser, (VerificationMode)Mockito.never())).setPassword((String)Mockito.any(String.class));
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(newUser);
    }

    @Test
    public void testUserCreateExistingFails() {
        User newUser = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.newUser("userId")).thenReturn((Object)newUser);
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("")}).when((Object)this.identityServiceMock)).saveUser(newUser);
        UserDto userDto = UserDto.fromUser((User)newUser, (boolean)true);
        RestAssured.given().body((Object)userDto).contentType(ContentType.JSON).then().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).when().post(USER_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newUser("userId");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(newUser);
        this.verifyLogs(Level.WARN, "org.camunda.bpm.engine.ProcessEngineException");
    }

    @Test
    public void testUserCreateThrowsAuthorizationException() {
        User newUser = MockProvider.createMockUser();
        String message = "exception expected";
        Mockito.when((Object)this.identityServiceMock.newUser("userId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        UserDto userDto = UserDto.fromUser((User)newUser, (boolean)true);
        RestAssured.given().body((Object)userDto).contentType(ContentType.JSON).then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(USER_CREATE_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    @Test
    public void testSaveNewUserThrowsAuthorizationException() {
        User newUser = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.newUser("userId")).thenReturn((Object)newUser);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).saveUser(newUser);
        UserDto userDto = UserDto.fromUser((User)newUser, (boolean)true);
        RestAssured.given().body((Object)userDto).contentType(ContentType.JSON).then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(USER_CREATE_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    @Test
    public void testPutCredentials() {
        User initialUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        UserCredentialsDto dto = new UserCredentialsDto();
        dto.setPassword("new-password");
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)dto).contentType(ContentType.JSON).then().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(USER_CREDENTIALS_URL, new Object[0]);
        ((User)Mockito.verify((Object)initialUser)).setPassword(dto.getPassword());
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(initialUser);
    }

    @Test
    public void testPutCredentialsThrowsAuthorizationException() {
        User initialUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).saveUser((User)Mockito.any(User.class));
        UserCredentialsDto dto = new UserCredentialsDto();
        dto.setPassword("new-password");
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)dto).contentType(ContentType.JSON).then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(USER_CREDENTIALS_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    @Test
    public void testChangeCredentials() {
        User initialUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        Authentication authentication = MockProvider.createMockAuthentication();
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.identityServiceMock.checkPassword("userId", "s3cret")).thenReturn((Object)true);
        UserCredentialsDto dto = new UserCredentialsDto();
        dto.setPassword("new-password");
        dto.setAuthenticatedUserPassword("s3cret");
        RestAssured.given().pathParam("id", (Object)"userId").contentType(ContentType.JSON).body((Object)dto).then().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(USER_CREDENTIALS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).getCurrentAuthentication();
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).checkPassword("userId", "s3cret");
        ((User)Mockito.verify((Object)initialUser)).setPassword(dto.getPassword());
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(initialUser);
    }

    @Test
    public void testChangeCredentialsWithWrongAuthenticatedUserPassword() {
        String exceptionMessage = "The given authenticated user password is not valid.";
        User initialUser = MockProvider.createMockUser();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        Authentication authentication = MockProvider.createMockAuthentication();
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.identityServiceMock.checkPassword("userId", "s3cret")).thenReturn((Object)false);
        UserCredentialsDto dto = new UserCredentialsDto();
        dto.setPassword("new-password");
        dto.setAuthenticatedUserPassword("s3cret");
        RestAssured.given().pathParam("id", (Object)"userId").contentType(ContentType.JSON).body((Object)dto).then().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)"InvalidRequestException"), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().put(USER_CREDENTIALS_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testPutCredentialsNonExistingUserFails() {
        String exceptionMessage = "User with id aNonExistingUser does not exist";
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("aNonExistingUser")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn(null);
        UserCredentialsDto dto = new UserCredentialsDto();
        dto.setPassword("new-password");
        RestAssured.given().pathParam("id", (Object)"aNonExistingUser").body((Object)dto).contentType(ContentType.JSON).then().then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().put(USER_CREDENTIALS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveUser((User)Mockito.any(User.class));
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testPutProfile() {
        User initialUser = MockProvider.createMockUser();
        User userUpdate = MockProvider.createMockUserUpdate();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        UserProfileDto updateDto = UserProfileDto.fromUser((User)userUpdate);
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)updateDto).contentType(ContentType.JSON).then().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(USER_PROFILE_URL, new Object[0]);
        ((User)Mockito.verify((Object)initialUser)).setEmail(updateDto.getEmail());
        ((User)Mockito.verify((Object)initialUser)).setFirstName(updateDto.getFirstName());
        ((User)Mockito.verify((Object)initialUser)).setLastName(updateDto.getLastName());
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveUser(initialUser);
    }

    @Test
    public void testPutProfileNonexistingFails() {
        String exceptionMessage = "User with id aNonExistingUser does not exist";
        User userUpdate = MockProvider.createMockUserUpdate();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("aNonExistingUser")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn(null);
        UserProfileDto updateDto = UserProfileDto.fromUser((User)userUpdate);
        RestAssured.given().pathParam("id", (Object)"aNonExistingUser").body((Object)updateDto).contentType(ContentType.JSON).then().then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().put(USER_PROFILE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveUser((User)Mockito.any(User.class));
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testPutProfileThrowsAuthorizationException() {
        User initialUser = MockProvider.createMockUser();
        User userUpdate = MockProvider.createMockUserUpdate();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)this.identityServiceMock.createUserQuery()).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userId("userId")).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)((User)sampleUserQuery.singleResult())).thenReturn((Object)initialUser);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).saveUser((User)Mockito.any(User.class));
        UserProfileDto updateDto = UserProfileDto.fromUser((User)userUpdate);
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)updateDto).contentType(ContentType.JSON).then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(USER_PROFILE_URL, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    @Test
    public void testReadOnlyUserCreateFails() {
        String exceptionMessage = "Identity service implementation is read-only.";
        User newUser = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().body((Object)UserDto.fromUser((User)newUser, (boolean)true)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().post(USER_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).newUser("userId");
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testReadOnlyPutUserProfileFails() {
        String exceptionMessage = "Identity service implementation is read-only.";
        User userUdpdate = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)UserProfileDto.fromUser((User)userUdpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().put(USER_PROFILE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveUser(userUdpdate);
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testReadOnlyPutUserCredentialsFails() {
        String exceptionMessage = "Identity service implementation is read-only.";
        User userUdpdate = MockProvider.createMockUser();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").body((Object)UserCredentialsDto.fromUser((User)userUdpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().put(USER_CREDENTIALS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveUser(userUdpdate);
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testReadOnlyUserDeleteFails() {
        String exceptionMessage = "Identity service implementation is read-only.";
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().delete(USER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteUser("userId");
        this.verifyLogs(Level.DEBUG, exceptionMessage);
    }

    @Test
    public void testUnlockUser() {
        RestAssured.given().pathParam("id", (Object)"userId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(USER_UNLOCK, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).unlockUser("userId");
    }

    @Test
    public void testUnlockUserNonExistingUser() {
        RestAssured.given().pathParam("id", (Object)"non-existing").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(USER_UNLOCK, new Object[0]);
    }

    @Test
    public void testUnlockUserThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.identityServiceMock)).unlockUser("userId");
        RestAssured.given().pathParam("id", (Object)"userId").then().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(USER_UNLOCK, new Object[0]);
        this.verifyLogs(Level.DEBUG, message);
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(Mockito.anyString(), Mockito.anyList(), (Permission)Mockito.any(Permission.class), (Resource)Mockito.any(Resource.class));
    }

    protected void verifyLogs(Level logLevel, String message) {
        List logs = this.loggingRule.getLog();
        Assertions.assertThat((List)logs).hasSize(1);
        Assertions.assertThat((Object)((ILoggingEvent)logs.get(0)).getLevel()).isEqualTo((Object)logLevel);
        Assertions.assertThat((String)((ILoggingEvent)logs.get(0)).getMessage()).containsIgnoringCase((CharSequence)message);
    }
}

