/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HistoricBatchRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_BATCH_RESOURCE_URL = "/rest-test/history/batch";
    protected static final String HISTORIC_BATCH_QUERY_COUNT_URL = "/rest-test/history/batch/count";
    protected HistoricBatchQuery queryMock;

    @Before
    public void setUpHistoricBatchQueryMock() {
        List<HistoricBatch> mockHistoricBatches = MockProvider.createMockHistoricBatches();
        this.queryMock = (HistoricBatchQuery)Mockito.mock(HistoricBatchQuery.class);
        Mockito.when((Object)this.queryMock.list()).thenReturn(mockHistoricBatches);
        Mockito.when((Object)this.queryMock.count()).thenReturn((Object)mockHistoricBatches.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricBatchQuery()).thenReturn((Object)this.queryMock);
    }

    @Test
    public void testNoParametersQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testUnknownQueryParameter() {
        Response response = (Response)RestAssured.given().queryParam("unknown", new Object[]{"unknown"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).batchId(Mockito.anyString());
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).list();
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"batchId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testHistoricBatchQueryByBatchId() {
        Response response = (Response)RestAssured.given().queryParam("batchId", new Object[]{"aBatchId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testHistoricBatchQueryByCompleted() {
        Response response = (Response)RestAssured.given().queryParam("completed", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).completed(true);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testHistoricBatchQueryByNotCompleted() {
        Response response = (Response)RestAssured.given().queryParam("completed", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).completed(false);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).list();
        inOrder.verifyNoMoreInteractions();
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testFullHistoricBatchQuery() {
        Response response = (Response)RestAssured.given().queryParams(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
        this.verifyHistoricBatchListJson(response.asString());
    }

    @Test
    public void testQueryCount() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_BATCH_QUERY_COUNT_URL, new Object[0]);
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_BATCH_QUERY_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.queryMock});
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "desc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("batchId", "asc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderById();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("startTime", "desc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByStartTime();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("startTime", "asc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByStartTime();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByEndTime();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByEndTime();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).orderByTenantId();
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).asc();
    }

    private void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_BATCH_RESOURCE_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", "aBatchId");
        parameters.put("type", "aBatchType");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).batchId("aBatchId");
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).type("aBatchType");
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).withoutTenantId();
    }

    protected void verifyHistoricBatchListJson(String historicBatchListJson) {
        List batches = (List)JsonPathUtil.from(historicBatchListJson).get();
        Assert.assertEquals((String)"There should be one historic batch returned.", (long)1L, (long)batches.size());
        HistoricBatchDto historicBatch = (HistoricBatchDto)JsonPathUtil.from(historicBatchListJson).getObject("[0]", HistoricBatchDto.class);
        Assert.assertNotNull((String)"The returned historic batch should not be null.", (Object)historicBatch);
        Assert.assertEquals((Object)"aBatchId", (Object)historicBatch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)historicBatch.getType());
        Assert.assertEquals((long)10L, (long)historicBatch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)historicBatch.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)historicBatch.getCreateUserId());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME), (Object)historicBatch.getStartTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_END_TIME), (Object)historicBatch.getEndTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_REMOVAL_TIME), (Object)historicBatch.getRemovalTime());
    }
}

