/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricCaseActivityInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL = "/rest-test/history/case-activity-instance";
    protected static final String HISTORIC_CASE_ACTIVITY_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/case-activity-instance/count";
    protected HistoricCaseActivityInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricCaseActivityInstanceQuery(MockProvider.createMockHistoricCaseActivityInstances());
    }

    protected HistoricCaseActivityInstanceQuery setUpMockHistoricCaseActivityInstanceQuery(List<HistoricCaseActivityInstance> mockedHistoricCaseActivityInstances) {
        HistoricCaseActivityInstanceQuery mockedHistoricCaseActivityInstanceQuery = (HistoricCaseActivityInstanceQuery)Mockito.mock(HistoricCaseActivityInstanceQuery.class);
        Mockito.when((Object)mockedHistoricCaseActivityInstanceQuery.list()).thenReturn(mockedHistoricCaseActivityInstances);
        Mockito.when((Object)mockedHistoricCaseActivityInstanceQuery.count()).thenReturn((Object)mockedHistoricCaseActivityInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseActivityInstanceQuery()).thenReturn((Object)mockedHistoricCaseActivityInstanceQuery);
        return mockedHistoricCaseActivityInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("caseInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("instanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"caseInstanceId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityInstanceId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityInstanceId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityName", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityName();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityName", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityName();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        this.executeAndVerifySorting("caseActivityType", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityType();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseActivityType", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseActivityType();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceCreateTime();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceCreateTime();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceEndTime();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceEndTime();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceDuration();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricCaseActivityInstanceDuration();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricActivityQuery() {
        String caseInstanceId = "aCaseInstId";
        Response response = (Response)RestAssured.given().queryParam("caseInstanceId", new Object[]{caseInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).caseInstanceId(caseInstanceId);
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedParentCaseActivityInstanceId = JsonPath.from((String)content).getString("[0].parentCaseActivityInstanceId");
        String returnedCaseActivityId = JsonPath.from((String)content).getString("[0].caseActivityId");
        String returnedCaseActivityName = JsonPath.from((String)content).getString("[0].caseActivityName");
        String returnedCaseActivityType = JsonPath.from((String)content).getString("[0].caseActivityType");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedCaseExecutionId = JsonPath.from((String)content).getString("[0].caseExecutionId");
        String returnedTaskId = JsonPath.from((String)content).getString("[0].taskId");
        String returnedCalledProcessInstanceId = JsonPath.from((String)content).getString("[0].calledProcessInstanceId");
        String returnedCalledCaseInstanceId = JsonPath.from((String)content).getString("[0].calledCaseInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Date returnedCreateTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].createTime"));
        Date returnedEndTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].endTime"));
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].durationInMillis");
        boolean required = JsonPath.from((String)content).getBoolean("[0].required");
        boolean available = JsonPath.from((String)content).getBoolean("[0].available");
        boolean enabled = JsonPath.from((String)content).getBoolean("[0].enabled");
        boolean disabled = JsonPath.from((String)content).getBoolean("[0].disabled");
        boolean active = JsonPath.from((String)content).getBoolean("[0].active");
        boolean completed = JsonPath.from((String)content).getBoolean("[0].completed");
        boolean terminated = JsonPath.from((String)content).getBoolean("[0].terminated");
        Assert.assertEquals((Object)"aCaseActivityInstanceId", (Object)returnedId);
        Assert.assertEquals((Object)"aParentCaseActivityId", (Object)returnedParentCaseActivityInstanceId);
        Assert.assertEquals((Object)"aCaseActivityId", (Object)returnedCaseActivityId);
        Assert.assertEquals((Object)"aCaseActivityName", (Object)returnedCaseActivityName);
        Assert.assertEquals((Object)"aCaseActivityType", (Object)returnedCaseActivityType);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)returnedCaseExecutionId);
        Assert.assertEquals((Object)"anId", (Object)returnedTaskId);
        Assert.assertEquals((Object)"aCalledProcessInstanceId", (Object)returnedCalledProcessInstanceId);
        Assert.assertEquals((Object)"aCalledCaseInstanceId", (Object)returnedCalledCaseInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATE_TIME), (Object)returnedCreateTime);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_END_TIME), (Object)returnedEndTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)true, (Object)required);
        Assert.assertEquals((Object)true, (Object)available);
        Assert.assertEquals((Object)true, (Object)enabled);
        Assert.assertEquals((Object)true, (Object)disabled);
        Assert.assertEquals((Object)true, (Object)active);
        Assert.assertEquals((Object)true, (Object)completed);
        Assert.assertEquals((Object)true, (Object)terminated);
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testBooleanParameters() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseActivityInstanceId", "aCaseActivityInstanceId");
        parameters.put("caseInstanceId", "aCaseInstId");
        parameters.put("caseDefinitionId", "aCaseDefnitionId");
        parameters.put("caseExecutionId", "aCaseExecutionId");
        parameters.put("caseActivityId", "aCaseActivityId");
        parameters.put("caseActivityName", "aCaseActivityName");
        parameters.put("caseActivityType", "aCaseActivityType");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityInstanceId(stringQueryParameters.get("caseActivityInstanceId"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(stringQueryParameters.get("caseDefinitionId"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId(stringQueryParameters.get("caseExecutionId"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityId(stringQueryParameters.get("caseActivityId"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityName(stringQueryParameters.get("caseActivityName"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityType(stringQueryParameters.get("caseActivityType"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, Boolean> getCompleteBooleanQueryParameters() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("required", true);
        parameters.put("finished", true);
        parameters.put("unfinished", true);
        parameters.put("available", true);
        parameters.put("enabled", true);
        parameters.put("disabled", true);
        parameters.put("active", true);
        parameters.put("completed", true);
        parameters.put("terminated", true);
        return parameters;
    }

    protected void verifyBooleanParameterQueryInvocations() {
        Map<String, Boolean> booleanParams = this.getCompleteBooleanQueryParameters();
        Boolean required = booleanParams.get("required");
        Boolean finished = booleanParams.get("finished");
        Boolean unfinished = booleanParams.get("unfinished");
        Boolean available = booleanParams.get("available");
        Boolean enabled = booleanParams.get("enabled");
        Boolean disabled = booleanParams.get("disabled");
        Boolean active = booleanParams.get("active");
        Boolean completed = booleanParams.get("completed");
        Boolean terminated = booleanParams.get("terminated");
        if (required != null && required.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).required();
        }
        if (finished != null && finished.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).ended();
        }
        if (unfinished != null && unfinished.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).notEnded();
        }
        if (available != null && available.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).available();
        }
        if (enabled != null && enabled.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).enabled();
        }
        if (disabled != null && disabled.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disabled();
        }
        if (active != null && active.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
        }
        if (completed != null && completed.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completed();
        }
        if (terminated != null && terminated.booleanValue()) {
            ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).terminated();
        }
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testFinishedHistoricCaseActivityQuery() {
        Response response = (Response)RestAssured.given().queryParam("finished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).ended();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_END_TIME, (Object)returnedActivityEndTime);
    }

    @Test
    public void testUnfinishedHistoricCaseActivityQuery() {
        List<HistoricCaseActivityInstance> mockedHistoricCaseActivityInstances = MockProvider.createMockRunningHistoricCaseActivityInstances();
        HistoricCaseActivityInstanceQuery mockedHistoricCaseActivityInstanceQuery = (HistoricCaseActivityInstanceQuery)Mockito.mock(HistoricCaseActivityInstanceQuery.class);
        Mockito.when((Object)mockedHistoricCaseActivityInstanceQuery.list()).thenReturn(mockedHistoricCaseActivityInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseActivityInstanceQuery()).thenReturn((Object)mockedHistoricCaseActivityInstanceQuery);
        Response response = (Response)RestAssured.given().queryParam("unfinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedHistoricCaseActivityInstanceQuery});
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)mockedHistoricCaseActivityInstanceQuery)).notEnded();
        ((HistoricCaseActivityInstanceQuery)inOrder.verify((Object)mockedHistoricCaseActivityInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertNull((Object)returnedActivityEndTime);
    }

    @Test
    public void testHistoricAfterAndBeforeCreateTimeQuery() {
        RestAssured.given().queryParam("createdAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATED_AFTER}).queryParam("createdBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATED_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCreateParameterQueryInvocations();
    }

    protected Map<String, Date> getCompleteCreateDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("createdAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATED_AFTER));
        parameters.put("createdBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATED_BEFORE));
        return parameters;
    }

    protected void verifyCreateParameterQueryInvocations() {
        Map<String, Date> startDateParameters = this.getCompleteCreateDateQueryParameters();
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdAfter(startDateParameters.get("createdAfter"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdBefore(startDateParameters.get("createdBefore"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testHistoricAfterAndBeforeEndTimeQuery() {
        RestAssured.given().queryParam("endedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_ENDED_AFTER}).queryParam("endedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_ENDED_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyEndedParameterQueryInvocations();
    }

    protected Map<String, Date> getCompleteEndedDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("endedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_ENDED_AFTER));
        parameters.put("endedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_ACTIVITY_INSTANCE_ENDED_BEFORE));
        return parameters;
    }

    protected void verifyEndedParameterQueryInvocations() {
        Map<String, Date> finishedDateParameters = this.getCompleteEndedDateQueryParameters();
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).endedAfter(finishedDateParameters.get("endedAfter"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).endedBefore(finishedDateParameters.get("endedBefore"));
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricCaseActivityInstanceQuery(this.createMockHistoricCaseActivityInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicCaseActivityInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicCaseActivityInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryWithoutTenantIdQueryParameter() {
        HistoricCaseActivityInstance caseInstance = MockProvider.createMockHistoricCaseActivityInstance(null);
        this.mockedQuery = this.setUpMockHistoricCaseActivityInstanceQuery(Collections.singletonList(caseInstance));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testCaseActivityInstanceIdListParameter() {
        RestAssured.given().queryParam("caseActivityInstanceIdIn", new Object[]{"aCaseActivityInstanceId,anotherCaseActivityInstanceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityInstanceIdIn(new String[]{"aCaseActivityInstanceId", "anotherCaseActivityInstanceId"});
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseActivityIdListParameter() {
        RestAssured.given().queryParam("caseActivityIdIn", new Object[]{"aCaseActivityId,anotherCaseActivityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityIdIn(new String[]{"aCaseActivityId", "anotherCaseActivityId"});
        ((HistoricCaseActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private List<HistoricCaseActivityInstance> createMockHistoricCaseActivityInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricCaseActivityInstance("aTenantId"), MockProvider.createMockHistoricCaseActivityInstance("anotherTenantId"));
    }
}

