/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricFormField;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockHistoricVariableUpdateBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HistoricDetailRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_DETAIL_RESOURCE_URL = "/rest-test/history/detail";
    protected static final String HISTORIC_DETAIL_COUNT_RESOURCE_URL = "/rest-test/history/detail/count";
    protected HistoricDetailQuery mockedQuery;
    protected HistoricVariableUpdate historicUpdateMock;
    protected MockHistoricVariableUpdateBuilder historicUpdateBuilder;
    protected HistoricFormField historicFormFieldMock;

    @Before
    public void setUpRuntimeData() {
        ArrayList<HistoricDetail> details = new ArrayList<HistoricDetail>();
        this.historicUpdateBuilder = MockProvider.mockHistoricVariableUpdate();
        this.historicUpdateMock = this.historicUpdateBuilder.build();
        this.historicFormFieldMock = MockProvider.createMockHistoricFormField();
        details.add((HistoricDetail)this.historicUpdateMock);
        details.add((HistoricDetail)this.historicFormFieldMock);
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
    }

    protected HistoricDetailQuery setUpMockedDetailsQuery(List<HistoricDetail> detailMocks) {
        HistoricDetailQuery mock = (HistoricDetailQuery)Mockito.mock(HistoricDetailQuery.class);
        Mockito.when((Object)mock.list()).thenReturn(detailMocks);
        Mockito.when((Object)mock.count()).thenReturn((Object)detailMocks.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricDetailQuery()).thenReturn((Object)mock);
        return mock;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryDisableObjectDeserialization() {
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySortingAsPost(OrderingBuilder.create().orderBy("processInstanceId").desc().orderBy("variableName").asc().orderBy("variableType").desc().orderBy("variableRevision").asc().orderBy("formPropertyId").desc().orderBy("time").asc().orderBy("occurrence").desc().orderBy("tenantId").asc().getJson(), Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableType();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableRevision();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByFormPropertyId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTime();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("processInstanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testInvalidSecondarySortingOptions() {
        this.executeAndVerifySortingAsPost(OrderingBuilder.create().orderBy("processInstanceId").desc().orderBy("invalidParameter").asc().getJson(), Response.Status.BAD_REQUEST);
    }

    @Test
    public void testMissingSecondarySortingOptions() {
        this.executeAndVerifySortingAsPost(OrderingBuilder.create().orderBy("processInstanceId").desc().orderBy("variableName").getJson(), Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
    }

    protected void executeAndVerifySortingAsPost(List<Map<String, Object>> sortingJson, Response.Status expectedStatus) {
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", sortingJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(json).then().expect().statusCode(expectedStatus.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableName", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableName", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("formPropertyId", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByFormPropertyId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("formPropertyId", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByFormPropertyId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableType", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableType();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableType", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableType();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableRevision", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableRevision();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableRevision", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableRevision();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("time", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTime();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("time", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTime();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).queryParam("maxResults", new Object[]{maxResults}).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).queryParam("firstResult", new Object[]{firstResult}).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_DETAIL_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricActivityQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].id", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getId()), new Object[0]).body("[0].variableName", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getName()), new Object[0]).body("[0].variableInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getVariableInstanceId()), new Object[0]).body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(this.historicUpdateBuilder.getTypedValue().getType())), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTypedValue().getValue()), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessDefinitionKey()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessDefinitionId()), new Object[0]).body("[0].processInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessInstanceId()), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getErrorMessage()), new Object[0]).body("[0].activityInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getActivityInstanceId()), new Object[0]).body("[0].revision", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getRevision()), new Object[0]).body("[0].time", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTime()), new Object[0]).body("[0].taskId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTaskId()), new Object[0]).body("[0].executionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getExecutionId()), new Object[0]).body("[0].type", CoreMatchers.equalTo((Object)"variableUpdate"), new Object[0]).body("[0].caseDefinitionKey", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseDefinitionKey()), new Object[0]).body("[0].caseDefinitionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseDefinitionId()), new Object[0]).body("[0].caseInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseInstanceId()), new Object[0]).body("[0].caseExecutionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseExecutionId()), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTenantId()), new Object[0]).body("[0].userOperationId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getUserOperationId()), new Object[0]).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).list();
        this.verifySimpleHistoricActivityQueryResponse(response);
    }

    @Test
    public void testSimpleHistoricActivityQueryPost() {
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].id", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getId()), new Object[0]).body("[0].variableName", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getName()), new Object[0]).body("[0].variableInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getVariableInstanceId()), new Object[0]).body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(this.historicUpdateBuilder.getTypedValue().getType())), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTypedValue().getValue()), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessDefinitionKey()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessDefinitionId()), new Object[0]).body("[0].processInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getProcessInstanceId()), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getErrorMessage()), new Object[0]).body("[0].activityInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getActivityInstanceId()), new Object[0]).body("[0].revision", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getRevision()), new Object[0]).body("[0].time", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTime()), new Object[0]).body("[0].taskId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTaskId()), new Object[0]).body("[0].executionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getExecutionId()), new Object[0]).body("[0].type", CoreMatchers.equalTo((Object)"variableUpdate"), new Object[0]).body("[0].caseDefinitionKey", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseDefinitionKey()), new Object[0]).body("[0].caseDefinitionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseDefinitionId()), new Object[0]).body("[0].caseInstanceId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseInstanceId()), new Object[0]).body("[0].caseExecutionId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getCaseExecutionId()), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getTenantId()), new Object[0]).body("[0].userOperationId", CoreMatchers.equalTo((Object)this.historicUpdateBuilder.getUserOperationId()), new Object[0]).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDetailQuery)inOrder.verify((Object)this.mockedQuery)).list();
        this.verifySimpleHistoricActivityQueryResponse(response);
    }

    private void verifySimpleHistoricActivityQueryResponse(Response response) {
        String content = response.asString();
        List details = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two activity instance returned.", (long)2L, (long)details.size());
        Assert.assertNotNull((String)"The returned details should not be null.", details.get(0));
        Assert.assertNotNull((String)"The returned details should not be null.", details.get(1));
        String returnedId2 = JsonPath.from((String)content).getString("[1].id");
        String returnedProcessDefinitionKey2 = JsonPath.from((String)content).getString("[1].processDefinitionKey");
        String returnedProcessDefinitionId2 = JsonPath.from((String)content).getString("[1].processDefinitionId");
        String returnedProcessInstanceId2 = JsonPath.from((String)content).getString("[1].processInstanceId");
        String returnedActivityInstanceId2 = JsonPath.from((String)content).getString("[1].activityInstanceId");
        String returnedExecutionId2 = JsonPath.from((String)content).getString("[1].executionId");
        String returnedTaskId2 = JsonPath.from((String)content).getString("[1].taskId");
        Date returnedTime2 = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[1].time"));
        Date returnedRemovalTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[1].removalTime"));
        String returnedFieldId = JsonPath.from((String)content).getString("[1].fieldId");
        String returnedFieldValue = JsonPath.from((String)content).getString("[1].fieldValue");
        String returnedType = JsonPath.from((String)content).getString("[1].type");
        String returnedCaseDefinitionKey2 = JsonPath.from((String)content).getString("[1].caseDefinitionKey");
        String returnedCaseDefinitionId2 = JsonPath.from((String)content).getString("[1].caseDefinitionId");
        String returnedCaseInstanceId2 = JsonPath.from((String)content).getString("[1].caseInstanceId");
        String returnedCaseExecutionId2 = JsonPath.from((String)content).getString("[1].caseExecutionId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        String returnedOperationId2 = JsonPath.from((String)content).getString("[1].userOperationId");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[1].rootProcessInstanceId");
        Assert.assertEquals((Object)"anId", (Object)returnedId2);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey2);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId2);
        Assert.assertEquals((Object)"aProcInst", (Object)returnedProcessInstanceId2);
        Assert.assertEquals((Object)"anActInst", (Object)returnedActivityInstanceId2);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId2);
        Assert.assertEquals((Object)"aTaskId", (Object)returnedTaskId2);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_FORM_FIELD_TIME), (Object)returnedTime2);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_FORM_FIELD_TIME), (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"aFormFieldId", (Object)returnedFieldId);
        Assert.assertEquals((Object)"aFormFieldValue", (Object)returnedFieldValue);
        Assert.assertEquals((Object)"formField", (Object)returnedType);
        Assert.assertEquals((Object)"aCaseDefId", (Object)returnedCaseDefinitionId2);
        Assert.assertEquals((Object)"aCaseDefKey", (Object)returnedCaseDefinitionKey2);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId2);
        Assert.assertEquals((Object)"aCaseExecId", (Object)returnedCaseExecutionId2);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId2);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId2);
        Assert.assertEquals((Object)"anOperationId", (Object)returnedOperationId2);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
    }

    @Test
    public void testSerializableVariableInstanceRetrieval() {
        ObjectValue serializedValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").create();
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate().typedValue((TypedValue)serializedValue);
        ArrayList<HistoricDetail> details = new ArrayList<HistoricDetail>();
        details.add((HistoricDetail)builder.build());
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)serializedValue.getType())), new Object[0]).body("[0].errorMessage", Matchers.nullValue(), new Object[0]).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)serializedValue.getType())), new Object[0]).body("[0].errorMessage", Matchers.nullValue(), new Object[0]).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testSpinVariableInstanceRetrieval() {
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate().typedValue(Variables.serializedObjectValue((String)"aSerializedValue").serializationDataFormat("aDataFormat").objectTypeName("aRootType").create());
        ArrayList<HistoricDetail> details = new ArrayList<HistoricDetail>();
        details.add((HistoricDetail)builder.build());
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("[0].errorMessage", Matchers.nullValue(), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("[0].valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aRootType"), new Object[0]).body("[0].valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("[0].errorMessage", Matchers.nullValue(), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("[0].valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aRootType"), new Object[0]).body("[0].valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testQueryByProcessInstanceId() {
        String processInstanceId = "aProcInst";
        RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("processInstanceId", processInstanceId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
    }

    @Test
    public void testQueryByExecutionId() {
        String executionId = "anExecutionId";
        RestAssured.given().queryParam("executionId", new Object[]{executionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).executionId(executionId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("executionId", executionId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).executionId(executionId);
    }

    @Test
    public void testQueryByOperationId() {
        String operationId = "anOperationId";
        RestAssured.given().queryParam("userOperationId", new Object[]{operationId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).userOperationId(operationId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("userOperationId", operationId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).userOperationId(operationId);
    }

    @Test
    public void testQueryByActivityInstanceId() {
        String activityInstanceId = "anActInst";
        RestAssured.given().queryParam("activityInstanceId", new Object[]{activityInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceId(activityInstanceId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("activityInstanceId", activityInstanceId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceId(activityInstanceId);
    }

    @Test
    public void testQueryByTaskId() {
        String taskId = "aTaskId";
        RestAssured.given().queryParam("taskId", new Object[]{taskId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).taskId(taskId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("taskId", taskId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).taskId(taskId);
    }

    @Test
    public void testQueryByVariableInstanceId() {
        String variableInstanceId = "aHistoricVariableUpdateId";
        RestAssured.given().queryParam("variableInstanceId", new Object[]{variableInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableInstanceId(variableInstanceId);
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("variableInstanceId", variableInstanceId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableInstanceId(variableInstanceId);
    }

    @Test
    public void testQueryByVariableTypeIn() {
        String aVariableType = "string";
        String anotherVariableType = "integer";
        RestAssured.given().queryParam("variableTypeIn", new Object[]{aVariableType + "," + anotherVariableType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableTypeIn(new String[]{aVariableType, anotherVariableType});
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String[]> jsonBody = new HashMap<String, String[]>();
        String[] variableTypeIn = new String[]{aVariableType, anotherVariableType};
        jsonBody.put("variableTypeIn", variableTypeIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableTypeIn(new String[]{aVariableType, anotherVariableType});
    }

    @Test
    public void testQueryByFormFields() {
        RestAssured.given().queryParam("formFields", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).formFields();
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, Boolean> jsonBody = new HashMap<String, Boolean>();
        jsonBody.put("formFields", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).formFields();
    }

    @Test
    public void testQueryByVariableUpdates() {
        RestAssured.given().queryParam("variableUpdates", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableUpdates();
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, Boolean> jsonBody = new HashMap<String, Boolean>();
        jsonBody.put("variableUpdates", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableUpdates();
    }

    @Test
    public void testQueryByExcludeTaskDetails() {
        RestAssured.given().queryParam("excludeTaskDetails", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).excludeTaskDetails();
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, Boolean> jsonBody = new HashMap<String, Boolean>();
        jsonBody.put("excludeTaskDetails", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).excludeTaskDetails();
    }

    @Test
    public void testQueryByCaseInstanceId() {
        RestAssured.given().queryParam("caseInstanceId", new Object[]{"aCaseInstId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId("aCaseInstId");
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("caseInstanceId", "aCaseInstId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId("aCaseInstId");
    }

    @Test
    public void testQueryByCaseExecutionId() {
        RestAssured.given().queryParam("caseExecutionId", new Object[]{"aCaseExecutionId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId("aCaseExecutionId");
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("caseExecutionId", "aCaseExecutionId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId("aCaseExecutionId");
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockedDetailsQuery(this.createMockHistoricDetailsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).queryParam("variableUpdates", new Object[]{"true"}).queryParam("formFields", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableUpdates();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).formFields();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        this.verifyTenantIdListParameterResponse(response);
        this.mockedQuery = this.setUpMockedDetailsQuery(this.createMockHistoricDetailsTwoTenants());
        HashMap<String, Object> jsonBody = new HashMap<String, Object>();
        String[] exampleTenantIdList = new String[]{"aTenantId", "anotherTenantId"};
        jsonBody.put("tenantIdIn", exampleTenantIdList);
        jsonBody.put("variableUpdates", true);
        jsonBody.put("formFields", true);
        response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).variableUpdates();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).formFields();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        this.verifyTenantIdListParameterResponse(response);
    }

    @Test
    public void testQueryWithoutTenantIdQueryParameter() {
        ArrayList<HistoricDetail> details = new ArrayList<HistoricDetail>();
        this.historicUpdateBuilder = MockProvider.mockHistoricVariableUpdate(null);
        this.historicUpdateMock = this.historicUpdateBuilder.build();
        this.historicFormFieldMock = MockProvider.createMockHistoricFormField(null);
        details.add((HistoricDetail)this.historicUpdateMock);
        details.add((HistoricDetail)this.historicFormFieldMock);
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testQueryWithoutTenantIdPostParameter() {
        ArrayList<HistoricDetail> details = new ArrayList<HistoricDetail>();
        this.historicUpdateBuilder = MockProvider.mockHistoricVariableUpdate(null);
        this.historicUpdateMock = this.historicUpdateBuilder.build();
        this.historicFormFieldMock = MockProvider.createMockHistoricFormField(null);
        details.add((HistoricDetail)this.historicUpdateMock);
        details.add((HistoricDetail)this.historicFormFieldMock);
        this.mockedQuery = this.setUpMockedDetailsQuery(details);
        Map<String, Boolean> queryParameters = Collections.singletonMap("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    private void verifyTenantIdListParameterResponse(Response response) {
        String content = response.asString();
        List historicDetails = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicDetails).hasSize(4);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        String returnedTenantId3 = JsonPath.from((String)content).getString("[2].tenantId");
        String returnedTenantId4 = JsonPath.from((String)content).getString("[3].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId3).isEqualTo((Object)"anotherTenantId");
        Assertions.assertThat((String)returnedTenantId4).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testByProcessInstanceIdIn() {
        String aProcessInstanceId = "aProcessInstanceId";
        String anotherProcessInstanceId = "anotherProcessInstanceId";
        RestAssured.given().queryParam("processInstanceIdIn", new Object[]{aProcessInstanceId + "," + anotherProcessInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId});
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String[]> jsonBody = new HashMap<String, String[]>();
        String[] processInstanceIdIn = new String[]{aProcessInstanceId, anotherProcessInstanceId};
        jsonBody.put("processInstanceIdIn", processInstanceIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId});
    }

    @Test
    public void testByOccurredBefore() {
        RestAssured.given().queryParam("occurredBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).occurredBefore(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME));
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("occurredBefore", MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).occurredBefore(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME));
    }

    @Test
    public void testByOccurredAfter() {
        RestAssured.given().queryParam("occurredAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).occurredAfter(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME));
        Mockito.reset((Object[])new HistoricDetailQuery[]{this.mockedQuery});
        HashMap<String, String> jsonBody = new HashMap<String, String>();
        jsonBody.put("occurredAfter", MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(jsonBody).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).occurredAfter(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_VAR_UPDATE_TIME));
    }

    @Test
    public void testGetQueryWhereFileWasDeleted() {
        ((HistoricVariableUpdate)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("Parameter 'filename' is null")}).when((Object)this.historicUpdateMock)).getTypedValue();
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testPostQueryWhereFileWasDeleted() {
        ((HistoricVariableUpdate)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("Parameter 'filename' is null")}).when((Object)this.historicUpdateMock)).getTypedValue();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(Collections.emptyMap()).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DETAIL_RESOURCE_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricDetailQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    private List<HistoricDetail> createMockHistoricDetailsTwoTenants() {
        List<HistoricDetail> mockHistoricDetails = MockProvider.createMockHistoricDetails("aTenantId");
        List<HistoricDetail> mockHistoricDetails2 = MockProvider.createMockHistoricDetails("anotherTenantId");
        mockHistoricDetails.addAll(mockHistoricDetails2);
        return mockHistoricDetails;
    }
}

