/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class AuthorizationRestServiceQueryTest
extends AbstractRestServiceTest {
    protected static final String SERVICE_PATH = "/rest-test/authorization";
    protected static final String SERVICE_COUNT_PATH = "/rest-test/authorization/count";
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected ProcessEngineConfigurationImpl processEngineConfigurationMock;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.processEngineConfigurationMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
        Mockito.when((Object)this.processEngineConfigurationMock.getPermissionProvider()).thenReturn((Object)new DefaultPermissionProvider());
    }

    private AuthorizationQuery setUpMockQuery(List<Authorization> list) {
        AuthorizationQuery query = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)query.list()).thenReturn(list);
        Mockito.when((Object)query.count()).thenReturn((Object)list.size());
        Mockito.when((Object)processEngine.getAuthorizationService().createAuthorizationQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void testEmptyQuery() {
        this.setUpMockQuery(MockProvider.createMockAuthorizations());
        String queryKey = "";
        RestAssured.given().queryParam("name", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"resourceType"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        AuthorizationQuery mockQuery = this.setUpMockQuery(MockProvider.createMockAuthorizations());
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SERVICE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockQuery});
    }

    @Test
    public void testSimpleAuthorizationQuery() {
        List<Authorization> mockAuthorizations = MockProvider.createMockGlobalAuthorizations();
        AuthorizationQuery mockQuery = this.setUpMockQuery(mockAuthorizations);
        Response response = (Response)RestAssured.given().queryParam("type", new Object[]{0}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SERVICE_PATH, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockQuery});
        ((AuthorizationQuery)inOrder.verify((Object)mockQuery)).authorizationType(Integer.valueOf(0));
        ((AuthorizationQuery)inOrder.verify((Object)mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one authorization returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned authorization should not be null.", instances.get(0));
        Authorization mockAuthorization = mockAuthorizations.get(0);
        Assert.assertEquals((Object)mockAuthorization.getId(), (Object)JsonPath.from((String)content).getString("[0].id"));
        Assert.assertEquals((long)mockAuthorization.getAuthorizationType(), (long)JsonPath.from((String)content).getInt("[0].type"));
        Assert.assertEquals((Object)Permissions.READ.getName(), (Object)JsonPath.from((String)content).getString("[0].permissions[0]"));
        Assert.assertEquals((Object)Permissions.UPDATE.getName(), (Object)JsonPath.from((String)content).getString("[0].permissions[1]"));
        Assert.assertEquals((Object)mockAuthorization.getUserId(), (Object)JsonPath.from((String)content).getString("[0].userId"));
        Assert.assertEquals((Object)mockAuthorization.getGroupId(), (Object)JsonPath.from((String)content).getString("[0].groupId"));
        Assert.assertEquals((long)mockAuthorization.getResourceType(), (long)JsonPath.from((String)content).getInt("[0].resourceType"));
        Assert.assertEquals((Object)mockAuthorization.getResourceId(), (Object)JsonPath.from((String)content).getString("[0].resourceId"));
        Assert.assertEquals((Object)mockAuthorization.getRemovalTime(), (Object)DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].removalTime")));
        Assert.assertEquals((Object)mockAuthorization.getRootProcessInstanceId(), (Object)JsonPath.from((String)content).getString("[0].rootProcessInstanceId"));
    }

    @Test
    public void testCompleteGetParameters() {
        List<Authorization> mockAuthorizations = MockProvider.createMockGlobalAuthorizations();
        AuthorizationQuery mockQuery = this.setUpMockQuery(mockAuthorizations);
        Map<String, String> queryParameters = this.getCompleteStringQueryParameters();
        RequestSpecification requestSpecification = RestAssured.given().contentType(POST_JSON_CONTENT_TYPE);
        for (Map.Entry<String, String> paramEntry : queryParameters.entrySet()) {
            requestSpecification.param(paramEntry.getKey(), new Object[]{paramEntry.getValue()});
        }
        requestSpecification.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SERVICE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).authorizationId("someAuthorizationId");
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).authorizationType(Integer.valueOf(0));
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).userIdIn(new String[]{"userId", "userId2"});
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).groupIdIn(new String[]{"groupId1", "groupId2"});
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).resourceType(12345678);
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).resourceId("exampleResourceId");
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).list();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", "someAuthorizationId");
        parameters.put("type", "0");
        parameters.put("userIdIn", "userId,userId2");
        parameters.put("groupIdIn", "groupId1,groupId2");
        parameters.put("resourceType", "12345678");
        parameters.put("resourceId", "exampleResourceId");
        return parameters;
    }

    @Test
    public void testQueryCount() {
        AuthorizationQuery mockQuery = this.setUpMockQuery(MockProvider.createMockAuthorizations());
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)3), new Object[0]).when().get(SERVICE_COUNT_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).count();
    }

    @Test
    public void testSuccessfulPagination() {
        AuthorizationQuery mockQuery = this.setUpMockQuery(MockProvider.createMockAuthorizations());
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SERVICE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)mockQuery)).listPage(firstResult, maxResults);
    }
}

