/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.management.SetJobRetriesBuilder;
import org.camunda.bpm.engine.management.SetJobRetriesByJobsAsyncBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateTenantBuilder;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockJobBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobRestServiceInteractionTest
extends AbstractRestServiceTest {
    private static final String RETRIES = "retries";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String JOB_RESOURCE_URL = "/rest-test/job";
    protected static final String SINGLE_JOB_RESOURCE_URL = "/rest-test/job/{id}";
    protected static final String JOB_RESOURCE_SET_RETRIES_URL = "/rest-test/job/{id}/retries";
    protected static final String JOBS_SET_RETRIES_URL = "/rest-test/job/retries";
    protected static final String JOB_RESOURCE_SET_PRIORITY_URL = "/rest-test/job/{id}/priority";
    protected static final String JOB_RESOURCE_EXECUTE_JOB_URL = "/rest-test/job/{id}/execute";
    protected static final String JOB_RESOURCE_GET_STACKTRACE_URL = "/rest-test/job/{id}/stacktrace";
    protected static final String JOB_RESOURCE_SET_DUEDATE_URL = "/rest-test/job/{id}/duedate";
    protected static final String JOB_RESOURCE_RECALC_DUEDATE_URL = "/rest-test/job/{id}/duedate/recalculate";
    protected static final String SINGLE_JOB_SUSPENDED_URL = "/rest-test/job/{id}/suspended";
    protected static final String JOB_SUSPENDED_URL = "/rest-test/job/suspended";
    private ProcessEngine namedProcessEngine;
    private ManagementService mockManagementService;
    private UpdateJobSuspensionStateTenantBuilder mockSuspensionStateBuilder;
    private UpdateJobSuspensionStateSelectBuilder mockSuspensionStateSelectBuilder;
    private JobQuery mockQuery;
    private SetJobRetriesByJobsAsyncBuilder mockSetJobRetriesByJobsAsyncBuilder;
    private SetJobRetriesBuilder mockSetJobRetriesBuilder;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = (JobQuery)Mockito.mock(JobQuery.class);
        Job mockedJob = new MockJobBuilder().id("aJobId").processInstanceId("aProcInstId").executionId("anExecutionId").retries(3).exceptionMessage("").failedActivityId("aFailedJobActivityId").dueDate(new Date()).priority(2147483689L).jobDefinitionId("aJobDefId").tenantId("aTenantId").createTime(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_CREATE_TIME)).batchId("aBatchId").build();
        Mockito.when((Object)((Job)this.mockQuery.singleResult())).thenReturn((Object)mockedJob);
        Mockito.when((Object)this.mockQuery.jobId("aJobId")).thenReturn((Object)this.mockQuery);
        this.mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)this.mockManagementService.createJobQuery()).thenReturn((Object)this.mockQuery);
        this.mockSetJobRetriesByJobsAsyncBuilder = MockProvider.createMockSetJobRetriesByJobsAsyncBuilder(this.mockManagementService);
        this.mockSetJobRetriesBuilder = MockProvider.createMockSetJobRetriesBuilder(this.mockManagementService);
        this.mockSuspensionStateSelectBuilder = (UpdateJobSuspensionStateSelectBuilder)Mockito.mock(UpdateJobSuspensionStateSelectBuilder.class);
        Mockito.when((Object)this.mockManagementService.updateJobSuspensionState()).thenReturn((Object)this.mockSuspensionStateSelectBuilder);
        this.mockSuspensionStateBuilder = (UpdateJobSuspensionStateTenantBuilder)Mockito.mock(UpdateJobSuspensionStateTenantBuilder.class);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byJobId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byJobDefinitionId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessInstanceId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionId(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionKey(ArgumentMatchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getManagementService()).thenReturn((Object)this.mockManagementService);
    }

    @Test
    public void testSetRetries() {
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, 3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).jobId("aJobId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesWithDueDate() {
        HashMap<String, Comparable<Integer>> retriesVariableJson = new HashMap<String, Comparable<Integer>>();
        retriesVariableJson.put(RETRIES, Integer.valueOf(3));
        Date newDueDate = new Date(1675752840000L);
        retriesVariableJson.put("dueDate", newDueDate);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).jobId("aJobId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).dueDate(newDueDate);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesWithNullDueDate() {
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, 3);
        retriesVariableJson.put("dueDate", null);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).jobId("aJobId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).dueDate(null);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesNonExistentJob() {
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((SetJobRetriesBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockSetJobRetriesBuilder)).execute();
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, 3);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(3);
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).jobId("aNonExistingJobId");
        ((SetJobRetriesBuilder)Mockito.verify((Object)this.mockSetJobRetriesBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesNegativeRetries() {
        String expectedMessage = "The number of job retries must be a non-negative Integer, but '-3' has been provided.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).setJobRetries(-3);
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, -3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(-3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockManagementService)).setJobRetries(ArgumentMatchers.anyInt());
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, -3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries(-3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSimpleJobGet() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aJobId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("executionId", Matchers.equalTo((Object)"anExecutionId"), new Object[0]).body("exceptionMessage", Matchers.equalTo((Object)""), new Object[0]).body("failedActivityId", Matchers.equalTo((Object)"aFailedJobActivityId"), new Object[0]).body("priority", Matchers.equalTo((Object)2147483689L), new Object[0]).body("jobDefinitionId", Matchers.equalTo((Object)"aJobDefId"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("createTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_JOB_CREATE_TIME), new Object[0]).body("batchId", Matchers.equalTo((Object)"aBatchId"), new Object[0]).when().get(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).jobId("aJobId");
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).singleResult();
    }

    @Test
    public void testJobGetIdDoesntExist() {
        JobQuery invalidQueryNonExistingJob = (JobQuery)Mockito.mock(JobQuery.class);
        Mockito.when((Object)this.mockManagementService.createJobQuery().jobId("aNonExistingJobId")).thenReturn((Object)invalidQueryNonExistingJob);
        Mockito.when((Object)((Job)invalidQueryNonExistingJob.singleResult())).thenReturn(null);
        String jobId = "aNonExistingJobId";
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Job with id " + jobId + " does not exist")), new Object[0]).when().get(SINGLE_JOB_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testExecuteJob() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).executeJob("aJobId");
    }

    @Test
    public void testExecuteJobIdDoesntExist() {
        String jobId = "aNonExistingJobId";
        String expectedMessage = "No job found with id '" + jobId + "'";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).executeJob("aNonExistingJobId");
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testExecuteJobRuntimeException() {
        String jobId = "aJobId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Runtime exception")}).when((Object)this.mockManagementService)).executeJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Runtime exception"), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testExecuteJobThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockManagementService)).executeJob(ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testGetStacktrace() {
        String stacktrace = "aStacktrace";
        Mockito.when((Object)this.mockManagementService.getJobExceptionStacktrace("aJobId")).thenReturn((Object)stacktrace);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
        String content = response.asString();
        Assert.assertEquals((Object)stacktrace, (Object)content);
    }

    @Test
    public void testGetStacktraceJobNotFound() {
        String exceptionMessage = "job not found";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(exceptionMessage)}).when((Object)this.mockManagementService)).getJobExceptionStacktrace("aJobId");
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }

    @Test
    public void testGetStacktraceJobThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockManagementService)).getJobExceptionStacktrace("aJobId");
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }

    @Test
    public void testSetJobDuedate() {
        Date newDuedate = MockProvider.createMockDuedate();
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", newDuedate, false);
    }

    @Test
    public void testSetJobDuedateNull() {
        HashMap<String, Object> duedateVariableJson = new HashMap<String, Object>();
        duedateVariableJson.put("duedate", null);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", null, false);
    }

    @Test
    public void testSetJobDuedateCascade() {
        Date newDuedate = MockProvider.createMockDuedate();
        HashMap<String, Comparable<Date>> duedateVariableJson = new HashMap<String, Comparable<Date>>();
        duedateVariableJson.put("duedate", newDuedate);
        duedateVariableJson.put("cascade", Boolean.valueOf(true));
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", newDuedate, true);
    }

    @Test
    public void testSetJobDuedateNullCascade() {
        HashMap<String, Boolean> duedateVariableJson = new HashMap<String, Boolean>();
        duedateVariableJson.put("duedate", null);
        duedateVariableJson.put("cascade", true);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", null, true);
    }

    @Test
    public void testSetJobDuedateNonExistentJob() {
        Date newDuedate = MockProvider.createMockDuedate();
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).setJobDuedate("aNonExistingJobId", newDuedate, false);
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aNonExistingJobId", newDuedate, false);
    }

    @Test
    public void testSetJobDuedateThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockManagementService)).setJobDuedate(ArgumentMatchers.anyString(), (Date)ArgumentMatchers.any(Date.class), ArgumentMatchers.anyBoolean());
        Date newDuedate = MockProvider.createMockDuedate();
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
    }

    @Test
    public void testActivateJob() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobId("aJobId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateThrowsProcessEngineException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateThrowsAuthorizationException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJob() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobId("aJobId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendedThrowsProcessEngineException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendWithMultipleByParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        params.put("processInstanceId", "aProcInstId");
        params.put("processDefinitionId", "aProcDefId");
        params.put("processDefinitionKey", "aKey");
        String message = "Only one of jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendThrowsAuthorizationException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateJobByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessInstanceId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessInstanceIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessInstanceIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessInstanceId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessInstanceIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessInstanceIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByJobDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobDefinitionId", "aJobDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByJobDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobDefinitionId", "aJobDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByJobDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByJobDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedException)}).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobId", "aJobId");
        String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobId", "aJobId");
        String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSetJobPriority() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
    }

    @Test
    public void testSetJobPriorityToExtremeValue() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", Long.MAX_VALUE);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", Long.MAX_VALUE);
    }

    @Test
    public void testSetJobPriorityNonExistentJob() {
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException(expectedMessage)}).when((Object)this.mockManagementService)).setJobPriority("aNonExistingJobId", 2147483689L);
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aNonExistingJobId", 2147483689L);
    }

    @Test
    public void testSetJobPriorityFailure() {
        String expectedMessage = "No job found with id 'aJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
    }

    @Test
    public void testSetNullJobPriorityFailure() {
        String expectedMessage = "Priority for job 'aJobId' cannot be null.";
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void testSetJobPriorityThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockManagementService)).setJobPriority((String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void deleteJob() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob("aJobId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteNotExistingJob() {
        String jobId = "aNonExistingJobId";
        String expectedMessage = "No job found with id '" + jobId + "'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new NullValueException(expectedMessage)}).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteLockedJob() {
        String jobId = "aJobId";
        String expectedMessage = "Cannot delete job when the job is being executed. Try again later.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteJobThrowAuthorizationException() {
        String jobId = "aJobId";
        String expectedMessage = "Missing permissions";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void testSetRetriesByJobsAsync() {
        List<String> ids = Arrays.asList("aProcInstId");
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", ids);
        messageBodyJson.put(RETRIES, 5);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(5);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds((List)ArgumentMatchers.eq(ids));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesAsyncWithDueDate() {
        List<String> ids = Arrays.asList("aProcInstId");
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", ids);
        Date newDueDate = new Date(1675752840000L);
        messageBodyJson.put("dueDate", newDueDate);
        messageBodyJson.put(RETRIES, 5);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(ArgumentMatchers.eq((int)5));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds((List)ArgumentMatchers.eq(ids));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).dueDate(newDueDate);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesAsyncWithNullDueDate() {
        List<String> ids = Arrays.asList("aProcInstId");
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", ids);
        messageBodyJson.put("dueDate", null);
        messageBodyJson.put(RETRIES, 5);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(ArgumentMatchers.eq((int)5));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds((List)ArgumentMatchers.eq(ids));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).dueDate(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesAsyncWithQuery() {
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("jobQuery", (Integer)query);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(5);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery((JobQuery)ArgumentMatchers.any(JobQuery.class));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesAsyncWithCreateTimesQuery() {
        HashMap<String, Serializable> messageBodyJson = new HashMap<String, Serializable>();
        messageBodyJson.put(RETRIES, Integer.valueOf(5));
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("operator", "lt");
        condition.put("value", "2022-12-15T10:45:00.000+0100");
        HashMap<String, List<Map>> jobQueryDto = new HashMap<String, List<Map>>();
        jobQueryDto.put("createTimes", Arrays.asList(condition));
        messageBodyJson.put("jobQuery", jobQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(5);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery((JobQuery)ArgumentMatchers.any(JobQuery.class));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesAsyncWithDueDatesQuery() {
        HashMap<String, Serializable> messageBodyJson = new HashMap<String, Serializable>();
        messageBodyJson.put(RETRIES, Integer.valueOf(5));
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("operator", "lt");
        condition.put("value", "2022-12-15T10:45:00.000+0100");
        HashMap<String, List<Map>> jobQueryDto = new HashMap<String, List<Map>>();
        jobQueryDto.put("dueDates", Arrays.asList(condition));
        messageBodyJson.put("jobQuery", jobQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesByJobsAsync(5);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobIds(null);
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).jobQuery((JobQuery)ArgumentMatchers.any(JobQuery.class));
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.verify((Object)this.mockSetJobRetriesByJobsAsyncBuilder, (VerificationMode)Mockito.times((int)1))).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesByJobsAsyncBuilder});
    }

    @Test
    public void testSetRetriesWithBadRequestQuery() {
        ((SetJobRetriesByJobsAsyncBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("job ids are empty")}).when((Object)this.mockSetJobRetriesByJobsAsyncBuilder)).jobQuery((JobQuery)ArgumentMatchers.eq((Object)null));
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesWithoutBody() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testSetRetriesWithNegativeRetries() {
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("retries are negative")}).when((Object)this.mockManagementService)).setJobRetriesByJobsAsync(ArgumentMatchers.eq((int)-3));
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, -3);
        JobQueryDto query = new JobQueryDto();
        messageBodyJson.put("jobQuery", (Integer)query);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesWithoutRetries() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", null);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSetJobRetriesBuilder});
    }

    @Test
    public void testRecalculateDuedateWithoutDateBase() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(JOB_RESOURCE_RECALC_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).recalculateJobDuedate("aJobId", true);
    }

    @Test
    public void testRecalculateDuedateCreationDateBased() {
        RestAssured.given().pathParam("id", (Object)"aJobId").queryParam("creationDateBased", new Object[]{true}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(JOB_RESOURCE_RECALC_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).recalculateJobDuedate("aJobId", true);
    }

    @Test
    public void testRecalculateDuedateCurrentDateBased() {
        RestAssured.given().pathParam("id", (Object)"aJobId").queryParam("creationDateBased", new Object[]{false}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(JOB_RESOURCE_RECALC_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).recalculateJobDuedate("aJobId", false);
    }

    @Test
    public void testRecalculateDuedateWithUnknownJobId() {
        String jobId = "aNonExistingJobId";
        String expectedMessage = "No job found with id '" + jobId + "'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException(expectedMessage)}).when((Object)this.mockManagementService)).recalculateJobDuedate(jobId, true);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().post(JOB_RESOURCE_RECALC_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).recalculateJobDuedate(jobId, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void testRecalculateDuedateUnauthorized() {
        String jobId = "aJobId";
        String expectedMessage = "Missing permissions";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.mockManagementService)).recalculateJobDuedate(jobId, true);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().post(JOB_RESOURCE_RECALC_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).recalculateJobDuedate(jobId, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }
}

