/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.SchemaLogEntryEntity;
import org.camunda.bpm.engine.management.SchemaLogEntry;
import org.camunda.bpm.engine.management.SchemaLogQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class SchemaLogRestServiceQueryTest
extends AbstractRestServiceTest {
    private static final String SCHEMA_LOG_URL = "/rest-test/schema/log";
    private static final String SCHEMA_LOG_ENTRY_MOCK_ID = "schema-log-entry-mock-id";
    private static final String SCHEMA_LOG_ENTRY_MOCK_VERSION = "schema-log-entry-mock-version";
    private static final Date SCHEMA_LOG_ENTRY_MOCK_TIMESTAMP = new Date();
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    private SchemaLogQuery mockedQuery;
    private List<SchemaLogEntry> mockedSchemaLogEntries;

    @Before
    public void init() {
        this.mockedQuery = (SchemaLogQuery)Mockito.mock(SchemaLogQuery.class);
        this.mockedSchemaLogEntries = this.createMockedSchemaLogEntries();
        Mockito.when((Object)this.mockedQuery.list()).thenReturn(this.mockedSchemaLogEntries);
        Mockito.when((Object)processEngine.getManagementService().createSchemaLogQuery()).thenReturn((Object)this.mockedQuery);
    }

    private List<SchemaLogEntry> createMockedSchemaLogEntries() {
        ArrayList<SchemaLogEntry> entries = new ArrayList<SchemaLogEntry>();
        SchemaLogEntryEntity entry = new SchemaLogEntryEntity();
        entry.setId(SCHEMA_LOG_ENTRY_MOCK_ID);
        entry.setVersion(SCHEMA_LOG_ENTRY_MOCK_VERSION);
        entry.setTimestamp(SCHEMA_LOG_ENTRY_MOCK_TIMESTAMP);
        entries.add((SchemaLogEntry)entry);
        return entries;
    }

    @Test
    public void testGetSchemaLog() {
        RestAssured.given().queryParam("version", new Object[]{SCHEMA_LOG_ENTRY_MOCK_VERSION}).queryParam("sortBy", new Object[]{"timestamp"}).queryParam("sortOrder", new Object[]{"asc"}).expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("[0].version", CoreMatchers.is((Object)SCHEMA_LOG_ENTRY_MOCK_VERSION), new Object[0]).body("[0].timestamp", CoreMatchers.notNullValue(), new Object[0]).when().get(SCHEMA_LOG_URL, new Object[0]);
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).version(SCHEMA_LOG_ENTRY_MOCK_VERSION);
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testGetSchemaLogAsPost() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", SCHEMA_LOG_ENTRY_MOCK_VERSION);
        params.put("sortBy", "timestamp");
        params.put("sortOrder", "asc");
        RestAssured.given().contentType("application/json").body(params).expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("[0].version", CoreMatchers.is((Object)SCHEMA_LOG_ENTRY_MOCK_VERSION), new Object[0]).body("[0].timestamp", CoreMatchers.notNullValue(), new Object[0]).when().post(SCHEMA_LOG_URL, new Object[0]);
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).version(SCHEMA_LOG_ENTRY_MOCK_VERSION);
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((SchemaLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }
}

