/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class StatisticsRestTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_DEFINITION_STATISTICS_URL = "/rest-test/process-definition/statistics";
    protected static final String ACTIVITY_STATISTICS_URL = "/rest-test/process-definition/{id}/statistics";
    protected static final String ACTIVITY_STATISTICS_BY_KEY_URL = "/rest-test/process-definition/key/{key}/statistics";
    private ProcessDefinitionStatisticsQuery processDefinitionStatisticsQueryMock;
    private ActivityStatisticsQuery activityQueryMock;
    private ProcessDefinitionQuery processDefinitionQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.setupProcessDefinitionStatisticsMock();
        this.setupActivityStatisticsMock();
        this.setupProcessDefinitionMock();
    }

    private void setupActivityStatisticsMock() {
        List<ActivityStatistics> mocks = MockProvider.createMockActivityStatistics();
        this.activityQueryMock = (ActivityStatisticsQuery)Mockito.mock(ActivityStatisticsQueryImpl.class);
        Mockito.when((Object)this.activityQueryMock.unlimitedList()).thenReturn(mocks);
        Mockito.when((Object)processEngine.getManagementService().createActivityStatisticsQuery((String)Mockito.any(String.class))).thenReturn((Object)this.activityQueryMock);
    }

    private void setupProcessDefinitionStatisticsMock() {
        List<ProcessDefinitionStatistics> mocks = MockProvider.createMockProcessDefinitionStatistics();
        this.processDefinitionStatisticsQueryMock = (ProcessDefinitionStatisticsQuery)Mockito.mock(ProcessDefinitionStatisticsQueryImpl.class);
        Mockito.when((Object)this.processDefinitionStatisticsQueryMock.unlimitedList()).thenReturn(mocks);
        Mockito.when((Object)processEngine.getManagementService().createProcessDefinitionStatisticsQuery()).thenReturn((Object)this.processDefinitionStatisticsQueryMock);
    }

    private void setupProcessDefinitionMock() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        this.processDefinitionQueryMock = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)this.processDefinitionQueryMock.processDefinitionKey("aKey")).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.tenantIdIn(new String[]{Mockito.anyString()})).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.withoutTenantId()).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.latestVersion()).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)((ProcessDefinition)this.processDefinitionQueryMock.singleResult())).thenReturn((Object)mockDefinition);
        Mockito.when((Object)this.processDefinitionQueryMock.list()).thenReturn(Collections.singletonList(mockDefinition));
        Mockito.when((Object)this.processDefinitionQueryMock.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getRepositoryService().createProcessDefinitionQuery()).thenReturn((Object)this.processDefinitionQueryMock);
    }

    @Test
    public void testStatisticsRetrievalPerProcessDefinitionVersion() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", Matchers.is((Object)2), new Object[0]).body("definition.size()", Matchers.is((Object)2), new Object[0]).body("definition.id", Matchers.hasItems((Object[])new String[]{"aProcDefId", "aProcessDefinitionId:2"}), new Object[0]).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testProcessDefinitionStatisticsRetrieval() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", Matchers.is((Object)2), new Object[0]).body("[0].definition.id", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("[0].definition.key", Matchers.equalTo((Object)"aKey"), new Object[0]).body("[0].definition.category", Matchers.equalTo((Object)"aCategory"), new Object[0]).body("[0].definition.name", Matchers.equalTo((Object)"aName"), new Object[0]).body("[0].definition.description", Matchers.equalTo((Object)"aDescription"), new Object[0]).body("[0].definition.deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("[0].definition.version", Matchers.equalTo((Object)42), new Object[0]).body("[0].definition.resource", Matchers.equalTo((Object)"aResourceName"), new Object[0]).body("[0].definition.diagram", Matchers.equalTo((Object)"aResourceName.png"), new Object[0]).body("[0].definition.tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("[0].definition.versionTag", Matchers.equalTo((Object)"aVersionTag"), new Object[0]).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testActivityStatisticsRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", Matchers.is((Object)2), new Object[0]).body("id", Matchers.hasItems((Object[])new String[]{"anActivity", "anotherActivity"}), new Object[0]).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testActivityStatisticsRetrievalByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", Matchers.is((Object)2), new Object[0]).body("id", Matchers.hasItems((Object[])new String[]{"anActivity", "anotherActivity"}), new Object[0]).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testAdditionalFailedJobsOption() {
        RestAssured.given().queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeFailedJobs();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }

    @Test
    public void testAdditionalIncidentsOption() {
        RestAssured.given().queryParam("incidents", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeIncidents();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }

    @Test
    public void testAdditionalIncidentsForTypeOption() {
        RestAssured.given().queryParam("incidentsForType", new Object[]{"failedJob"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeIncidentsForType("failedJob");
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }

    @Test
    public void testAdditionalIncidentsAndFailedJobsOption() {
        RestAssured.given().queryParam("incidents", new Object[]{"true"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeFailedJobs();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeIncidents();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }

    @Test
    public void testAdditionalIncidentsForTypeAndFailedJobsOption() {
        RestAssured.given().queryParam("incidentsForType", new Object[]{"failedJob"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeFailedJobs();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeIncidentsForType("failedJob");
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }

    @Test
    public void testAdditionalIncidentsAndIncidentsForType() {
        RestAssured.given().queryParam("incidents", new Object[]{"true"}).queryParam("incidentsForType", new Object[]{"anIncidentTpye"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testActivityStatisticsWithFailedJobs() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivityStatisticsWithFailedJobsByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivityStatisticsWithIncidents() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("incidents", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidents();
        ((ActivityStatisticsQueryImpl)inOrder.verify((Object)((ActivityStatisticsQueryImpl)this.activityQueryMock))).unlimitedList();
    }

    @Test
    public void testActivityStatisticsWithIncidentsByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("incidents", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidents();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivityStatisticsIncidentsForTypeTypeOption() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("incidentsForType", new Object[]{"failedJob"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidentsForType("failedJob");
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivityStatisticsIncidentsForTypeTypeOptionByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("incidentsForType", new Object[]{"failedJob"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidentsForType("failedJob");
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivtyStatisticsIncidentsAndFailedJobsOption() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("incidents", new Object[]{"true"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidents();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivtyStatisticsIncidentsAndFailedJobsOptionByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("incidents", new Object[]{"true"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidents();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivtyStatisticsIncidentsForTypeAndFailedJobsOption() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("incidentsForType", new Object[]{"failedJob"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidentsForType("failedJob");
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivtyStatisticsByIdThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.activityQueryMock.unlimitedList()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testActivtyStatisticsIncidentsForTypeAndFailedJobsOptionByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("incidentsForType", new Object[]{"failedJob"}).queryParam("failedJobs", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityQueryMock});
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeFailedJobs();
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).includeIncidentsForType("failedJob");
        ((ActivityStatisticsQuery)inOrder.verify((Object)this.activityQueryMock)).unlimitedList();
    }

    @Test
    public void testActivtyStatisticsIncidentsAndIncidentsForType() {
        RestAssured.given().pathParam("id", (Object)"aDefinitionId").queryParam("incidents", new Object[]{"true"}).queryParam("incidentsForType", new Object[]{"anIncidentTpye"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testActivtyStatisticsIncidentsAndIncidentsForTypeByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("incidents", new Object[]{"true"}).queryParam("incidentsForType", new Object[]{"anIncidentTpye"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testActivtyStatisticsByIdThrowsAuthorizationExceptionByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.activityQueryMock.unlimitedList()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(ACTIVITY_STATISTICS_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testProcessDefinitionStatisticsWithRootIncidents() {
        RestAssured.given().queryParam("rootIncidents", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processDefinitionStatisticsQueryMock});
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).includeRootIncidents();
        ((ProcessDefinitionStatisticsQuery)inOrder.verify((Object)this.processDefinitionStatisticsQueryMock)).unlimitedList();
    }
}

