/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.MockVariableInstanceBuilder;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class VariableInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String SERVICE_URL = "/rest-test/variable-instance";
    protected static final String VARIABLE_INSTANCE_URL = "/rest-test/variable-instance/{id}";
    protected static final String VARIABLE_INSTANCE_BINARY_DATA_URL = "/rest-test/variable-instance/{id}/data";
    protected RuntimeService runtimeServiceMock;
    protected VariableInstanceQuery variableInstanceQueryMock;

    @Before
    public void setupTestData() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        this.variableInstanceQueryMock = (VariableInstanceQuery)Mockito.mock(VariableInstanceQuery.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        Mockito.when((Object)this.runtimeServiceMock.createVariableInstanceQuery()).thenReturn((Object)this.variableInstanceQueryMock);
    }

    @Test
    public void testGetSingleVariableInstance() {
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance();
        VariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)builder.getTypedValue().getValue()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("batchId", CoreMatchers.equalTo((Object)builder.getBatchId()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetSingleVariableInstanceDeserialized() {
        MockObjectValue serializedValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)"a value").serializationDataFormat("aDataFormat").create()).objectTypeName("aTypeName");
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance().typedValue((TypedValue)serializedValue);
        VariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("batchId", CoreMatchers.equalTo((Object)builder.getBatchId()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableInstanceSerialized() {
        ObjectValue serializedValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("aDataFormat").objectTypeName("aTypeName").create();
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance().typedValue((TypedValue)serializedValue);
        VariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("batchId", CoreMatchers.equalTo((Object)builder.getBatchId()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableInstanceForBinaryVariable() {
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance();
        VariableInstance variableInstanceMock = builder.typedValue((TypedValue)Variables.byteArrayValue(null)).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.BYTES)), new Object[0]).body("value", CoreMatchers.nullValue(), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(nonExistingId)).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Variable instance with Id 'nonExistingId' does not exist."), new Matcher[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForBinaryVariable() {
        byte[] byteContent = "some bytes".getBytes();
        VariableInstance variableInstanceMock = MockProvider.mockVariableInstance().typedValue((TypedValue)Variables.byteArrayValue((byte[])byteContent)).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.BINARY.toString()).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        byte[] responseBytes = response.getBody().asByteArray();
        Assert.assertEquals((Object)new String(byteContent), (Object)new String(responseBytes));
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock)).disableCustomObjectDeserialization();
    }

    @Test
    public void testBinaryDataForNonBinaryVariable() {
        VariableInstance variableInstanceMock = MockProvider.createMockVariableInstance();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(CoreMatchers.containsString((String)"Value of variable with id aVariableInstanceId is not a binary value"), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock)).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetBinaryDataForNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(nonExistingId)).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Variable instance with Id 'nonExistingId' does not exist."), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock)).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetBinaryDataForFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = "test".getBytes();
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance();
        VariableInstance variableInstanceMock = builder.typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().header("Content-Disposition", "attachment; filename=\"" + filename + "\"; filename*=UTF-8''" + filename).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        String contentType = response.getContentType();
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.is((Matcher)CoreMatchers.either((Matcher)CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + "; charset=UTF-8"))).or(CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + ";charset=UTF-8")))));
    }

    @Test
    public void testGetBinaryDataForNullFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = null;
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        MockVariableInstanceBuilder builder = MockProvider.mockVariableInstance();
        VariableInstance variableInstanceMock = builder.typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)((VariableInstance)this.variableInstanceQueryMock.singleResult())).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().contentType(ContentType.TEXT).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String())), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
    }
}

