/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.application;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.rest.exception.RestException;

@Path(value="/unannotated")
public class UnannotatedResource {
    @GET
    @Path(value="/exception")
    public String throwAnException() throws Exception {
        throw new Exception("expected exception");
    }

    @GET
    @Path(value="/processEngineException")
    public String throwProcessEngineException() throws Exception {
        throw new ProcessEngineException("expected exception");
    }

    @GET
    @Path(value="/restException")
    public String throwRestException() throws Exception {
        throw new RestException(Response.Status.BAD_REQUEST, "expected exception");
    }

    @GET
    @Path(value="/authorizationException")
    public String throwAuthorizationException() throws Exception {
        throw new AuthorizationException("someUser", "somePermission", "someResourceName", "someResourceId");
    }

    @GET
    @Path(value="/stackOverflowError")
    public String throwStackOverflowError() throws Throwable {
        throw new StackOverflowError("Stack overflow");
    }

    @GET
    @Path(value="/authorizationExceptionMultiple")
    public String throwAuthorizationExceptionMultiple() throws Exception {
        ArrayList<MissingAuthorization> missingAuthorizations = new ArrayList<MissingAuthorization>();
        missingAuthorizations.add(new MissingAuthorization("somePermission1", "someResourceName1", "someResourceId1"));
        missingAuthorizations.add(new MissingAuthorization("somePermission2", "someResourceName2", "someResourceId2"));
        throw new AuthorizationException("someUser", missingAuthorizations);
    }
}

