/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.optimize;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockHistoricVariableUpdateBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class OptimizeVariableUpdateRestServiceTest
extends AbstractRestServiceTest {
    public static final String OPTIMIZE_VARIABLE_UPDATE_PATH = "/rest-test/optimize/variable-update";
    protected OptimizeService mockedOptimizeService;
    protected ProcessEngine namedProcessEngine;
    protected HistoricVariableUpdate historicUpdateMock;
    protected MockHistoricVariableUpdateBuilder historicUpdateBuilder;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.historicUpdateBuilder = MockProvider.mockHistoricVariableUpdate();
        this.historicUpdateMock = this.historicUpdateBuilder.build();
        this.mockedOptimizeService = (OptimizeService)Mockito.mock(OptimizeService.class);
        ProcessEngineConfigurationImpl mockedConfig = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)this.mockedOptimizeService.getHistoricVariableUpdates((Date)Mockito.any(Date.class), (Date)Mockito.any(Date.class), Mockito.anyBoolean(), Mockito.anyInt())).thenReturn(Arrays.asList(this.historicUpdateMock));
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getProcessEngineConfiguration()).thenReturn((Object)mockedConfig);
        Mockito.when((Object)mockedConfig.getOptimizeService()).thenReturn((Object)this.mockedOptimizeService);
    }

    @Test
    public void testNoQueryParameters() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(null, null, false, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testOccurredAfterQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("occurredAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(now, null, false, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testOccurredAtQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("occurredAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(null, now, false, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testExcludeObjectValuesQueryParameter() {
        RestAssured.given().queryParam("excludeObjectValues", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(null, null, true, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testMaxResultsQueryParameter() {
        RestAssured.given().queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(null, null, false, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testQueryParameterCombination() {
        Date now = new Date();
        RestAssured.given().queryParam("occurredAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("occurredAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("excludeObjectValues", new Object[]{true}).queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(now, now, true, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testQueryWhenFileWasDeleted() {
        ((HistoricVariableUpdate)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("Parameter 'filename' is null")}).when((Object)this.historicUpdateMock)).getTypedValue();
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricVariableUpdates(null, null, false, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testPresenceOfSequenceCounterProperty() {
        HistoricDetailVariableInstanceUpdateEntity mock = (HistoricDetailVariableInstanceUpdateEntity)Mockito.mock(HistoricDetailVariableInstanceUpdateEntity.class);
        Mockito.when((Object)mock.getSequenceCounter()).thenReturn((Object)10L);
        Mockito.when((Object)mock.getTypedValue()).thenReturn((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE);
        Mockito.when((Object)this.mockedOptimizeService.getHistoricVariableUpdates(null, null, false, Integer.MAX_VALUE)).thenReturn(Collections.singletonList(mock));
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_VARIABLE_UPDATE_PATH, new Object[0]);
        String content = response.asString();
        long sequenceCounter = JsonPath.from((String)content).getLong("[0].sequenceCounter");
        Assert.assertEquals((long)10L, (long)sequenceCounter);
    }
}

