/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.autodeployment;

import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.spring.test.autodeployment.DynamicResourceProducer;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringAutoDeployTest
extends PvmTestCase {
    protected static final String CTX_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployTest-context.xml";
    protected static final String CTX_CREATE_DROP_CLEAN_DB = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployTest-create-drop-clean-db-context.xml";
    protected static final String CTX_DYNAMIC_DEPLOY_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployTest-dynamic-deployment-context.xml";
    protected static final String CTX_CMMN_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployCmmnTest-context.xml";
    protected static final String CTX_CMMN_BPMN_TOGETHER_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployCmmnBpmnTest-context.xml";
    protected static final String CTX_DEPLOY_CHANGE_ONLY_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployDeployChangeOnlyTest-context.xml";
    protected static final String CTX_TENANT_ID_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployTenantIdTest-context.xml";
    protected static final String CTX_CUSTOM_NAME_PATH = "org/camunda/bpm/engine/spring/test/autodeployment/SpringAutoDeployCustomNameTest-context.xml";
    protected ApplicationContext applicationContext;
    protected RepositoryService repositoryService;

    protected void createAppContext(String path) {
        this.applicationContext = new ClassPathXmlApplicationContext(path);
        this.repositoryService = (RepositoryService)this.applicationContext.getBean(RepositoryService.class);
    }

    protected void tearDown() throws Exception {
        DynamicResourceProducer.clearResources();
        this.removeAllDeployments();
        this.applicationContext = null;
        this.repositoryService = null;
        super.tearDown();
    }

    public void testBasicActivitiSpringIntegration() {
        this.createAppContext(CTX_PATH);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        HashSet<String> processDefinitionKeys = new HashSet<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionKeys.add(processDefinition.getKey());
        }
        HashSet<String> expectedProcessDefinitionKeys = new HashSet<String>();
        expectedProcessDefinitionKeys.add("a");
        expectedProcessDefinitionKeys.add("b");
        expectedProcessDefinitionKeys.add("c");
        SpringAutoDeployTest.assertEquals(expectedProcessDefinitionKeys, processDefinitionKeys);
    }

    public void testNoRedeploymentForSpringContainerRestart() throws Exception {
        this.createAppContext(CTX_PATH);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        SpringAutoDeployTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        SpringAutoDeployTest.assertEquals((long)3L, (long)processDefinitionQuery.count());
        ((AbstractXmlApplicationContext)this.applicationContext).destroy();
        this.applicationContext = new ClassPathXmlApplicationContext(CTX_PATH);
        SpringAutoDeployTest.assertEquals((long)1L, (long)deploymentQuery.count());
        SpringAutoDeployTest.assertEquals((long)3L, (long)processDefinitionQuery.count());
    }

    public void testAutoDeployCmmn() {
        this.createAppContext(CTX_CMMN_PATH);
        List definitions = this.repositoryService.createCaseDefinitionQuery().list();
        SpringAutoDeployTest.assertEquals((int)1, (int)definitions.size());
    }

    public void testAutoDeployCmmnAndBpmnTogether() {
        this.createAppContext(CTX_CMMN_BPMN_TOGETHER_PATH);
        long caseDefs = this.repositoryService.createCaseDefinitionQuery().count();
        long procDefs = this.repositoryService.createProcessDefinitionQuery().count();
        SpringAutoDeployTest.assertEquals((long)1L, (long)caseDefs);
        SpringAutoDeployTest.assertEquals((long)3L, (long)procDefs);
    }

    public void testDeployChangeOnly() throws Exception {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"model1").startEvent("oldId").endEvent().done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"model1").startEvent("newId").endEvent().done();
        BpmnModelInstance model3 = Bpmn.createExecutableProcess((String)"model2").startEvent().endEvent().done();
        DynamicResourceProducer.addResource("a.bpmn", model1);
        DynamicResourceProducer.addResource("b.bpmn", model3);
        this.createAppContext(CTX_DEPLOY_CHANGE_ONLY_PATH);
        SpringAutoDeployTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        ((AbstractXmlApplicationContext)this.applicationContext).destroy();
        DynamicResourceProducer.clearResources();
        DynamicResourceProducer.addResource("a.bpmn", model2);
        DynamicResourceProducer.addResource("b.bpmn", model3);
        this.applicationContext = new ClassPathXmlApplicationContext(CTX_DEPLOY_CHANGE_ONLY_PATH);
        this.repositoryService = (RepositoryService)this.applicationContext.getBean("repositoryService");
        SpringAutoDeployTest.assertEquals((long)2L, (long)this.repositoryService.createDeploymentQuery().count());
        SpringAutoDeployTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    public void testResourceRedeploymentAfterProcessDefinitionChange() throws Exception {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"model1").startEvent("oldId").endEvent().done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"model1").startEvent("newId").endEvent().done();
        BpmnModelInstance model3 = Bpmn.createExecutableProcess((String)"model2").startEvent().endEvent().done();
        DynamicResourceProducer.addResource("a.bpmn", model1);
        DynamicResourceProducer.addResource("b.bpmn", model3);
        this.createAppContext(CTX_DYNAMIC_DEPLOY_PATH);
        SpringAutoDeployTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        ((AbstractXmlApplicationContext)this.applicationContext).destroy();
        DynamicResourceProducer.clearResources();
        DynamicResourceProducer.addResource("a.bpmn", model2);
        DynamicResourceProducer.addResource("b.bpmn", model3);
        this.applicationContext = new ClassPathXmlApplicationContext(CTX_DYNAMIC_DEPLOY_PATH);
        this.repositoryService = (RepositoryService)this.applicationContext.getBean("repositoryService");
        SpringAutoDeployTest.assertEquals((long)2L, (long)this.repositoryService.createDeploymentQuery().count());
        SpringAutoDeployTest.assertEquals((long)4L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    public void testAutoDeployWithCreateDropOnCleanDb() {
        this.createAppContext(CTX_CREATE_DROP_CLEAN_DB);
        SpringAutoDeployTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        SpringAutoDeployTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    public void testAutoDeployTenantId() {
        this.createAppContext(CTX_TENANT_ID_PATH);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        SpringAutoDeployTest.assertEquals((long)1L, (long)deploymentQuery.tenantIdIn(new String[]{"tenant1"}).count());
    }

    public void testAutoDeployWithoutTenantId() {
        this.createAppContext(CTX_CMMN_BPMN_TOGETHER_PATH);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        SpringAutoDeployTest.assertEquals((long)1L, (long)deploymentQuery.withoutTenantId().count());
    }

    public void testAutoDeployCustomName() {
        this.createAppContext(CTX_CUSTOM_NAME_PATH);
        SpringAutoDeployTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    private void removeAllDeployments() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

