/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring;

import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringConfigurationHelper {
    private static Logger log = Logger.getLogger(SpringConfigurationHelper.class.getName());

    public static ProcessEngine buildProcessEngine(URL resource) {
        log.fine("==== BUILDING SPRING APPLICATION CONTEXT AND PROCESS ENGINE =========================================");
        GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});
        Map beansOfType = applicationContext.getBeansOfType(ProcessEngine.class);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new ProcessEngineException("no " + ProcessEngine.class.getName() + " defined in the application context " + resource.toString());
        }
        ProcessEngine processEngine = (ProcessEngine)beansOfType.values().iterator().next();
        log.fine("==== SPRING PROCESS ENGINE CREATED ==================================================================");
        return processEngine;
    }
}

