/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components;

import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.components.ProcessInitiatingPojo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/components/ProcessStartingBeanPostProcessorTest-context.xml"})
public class ProcessStartingBeanPostProcessorTest {
    private Logger log = Logger.getLogger(this.getClass().getName());
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ProcessInitiatingPojo processInitiatingPojo;
    @Autowired
    private RepositoryService repositoryService;

    @Before
    public void before() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/spring/test/autodeployment/autodeploy.b.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/spring/test/components/waiter.bpmn20.xml").deploy();
    }

    @After
    public void after() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        this.processEngine.close();
        this.processEngine = null;
        this.processInitiatingPojo = null;
        this.repositoryService = null;
    }

    @Test
    public void testReturnedProcessInstance() throws Throwable {
        String processInstanceId = this.processInitiatingPojo.startProcessA(22L);
        Assert.assertNotNull((String)"the process instance id should not be null", (Object)processInstanceId);
    }

    @Test
    public void testReflectingSideEffects() throws Throwable {
        Assert.assertNotNull((String)"the processInitiatingPojo mustn't be null.", (Object)this.processInitiatingPojo);
        this.processInitiatingPojo.reset();
        Assert.assertEquals((long)this.processInitiatingPojo.getMethodState(), (long)0L);
        this.processInitiatingPojo.startProcess(53L);
        Assert.assertEquals((long)this.processInitiatingPojo.getMethodState(), (long)1L);
    }

    @Test
    public void testUsingBusinessKey() throws Throwable {
        long id = 5L;
        String businessKey = "usersKey" + System.currentTimeMillis();
        ProcessInstance pi = this.processInitiatingPojo.enrollCustomer(businessKey, id);
        Assert.assertEquals((String)"the business key of the resultant ProcessInstance should match the one specified through the AOP-intercepted method", (Object)businessKey, (Object)pi.getBusinessKey());
    }

    @Test
    public void testLaunchingProcessInstance() {
        long id = 343L;
        String processInstance = this.processInitiatingPojo.startProcessA(id);
        Long customerId = (Long)this.processEngine.getRuntimeService().getVariable(processInstance, "customerId");
        Assert.assertEquals((String)("the process variable should both exist and be equal to the value given, " + id), (Object)customerId, (Object)id);
        this.log.info("the customerId fromt he ProcessInstance is " + customerId);
        Assert.assertNotNull((String)"processInstanc can't be null", (Object)processInstance);
        Assert.assertNotNull((String)"the variable should be non-null", (Object)customerId);
    }
}

