/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction;

import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/transaction/SpringTransactionIntegrationDeleteDeploymentFailTest-context.xml"})
public class SpringTransactionIntegrationDeleteDeploymentFailTest
extends SpringProcessEngineTestCase {
    private String deploymentId;

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getDeploymentManager().deleteDeployment(SpringTransactionIntegrationDeleteDeploymentFailTest.this.deploymentId, false, false, false);
                return null;
            }
        });
        super.tearDown();
    }

    public void testFailingAfterDeleteDeployment() {
        BpmnModelInstance model = Bpmn.createExecutableProcess().startEvent().userTask().endEvent().done();
        this.deploymentId = this.processEngine.getRepositoryService().createDeployment().addModelInstance("model.bpmn", model).deploy().getId();
        try {
            this.processEngine.getRepositoryService().deleteDeployment(this.deploymentId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpringTransactionIntegrationDeleteDeploymentFailTest.assertEquals((int)1, (int)this.processEngineConfiguration.getRegisteredDeployments().size());
    }
}

