/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction;

import javax.sql.DataSource;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class UserBean {
    private RuntimeService runtimeService;
    private TaskService taskService;
    private DataSource dataSource;

    @Transactional
    public void hello() {
        this.runtimeService.startProcessInstanceByKey("helloProcess");
    }

    @Transactional
    public void completeTask(String taskId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int nrOfRows = jdbcTemplate.update("insert into MY_TABLE values ('test');");
        if (nrOfRows != 1) {
            throw new RuntimeException("Insert into MY_TABLE failed");
        }
        this.taskService.complete(taskId);
    }

    @Required
    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Required
    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

