/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction;

import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.engine.spring.test.transaction.UserBean;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/transaction/SpringTransactionIntegrationTest-context.xml"})
public class SpringTransactionIntegrationTest
extends SpringProcessEngineTestCase {
    @Autowired
    protected UserBean userBean;
    @Autowired
    protected DataSource dataSource;
    private static long WAIT_TIME_MILLIS = TimeUnit.MILLISECONDS.convert(20L, TimeUnit.SECONDS);

    @Deployment
    public void testBasicActivitiSpringIntegration() {
        this.userBean.hello();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        SpringTransactionIntegrationTest.assertEquals((Object)"Hello from Printer!", (Object)this.runtimeService.getVariable(processInstance.getId(), "myVar"));
    }

    @Deployment
    public void testRollbackTransactionOnActivitiException() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.execute("create table MY_TABLE (MY_TEXT varchar);");
        this.userBean.hello();
        int results = (Integer)jdbcTemplate.queryForObject("select count(*) from MY_TABLE", Integer.class);
        SpringTransactionIntegrationTest.assertEquals((int)0, (int)results);
        try {
            this.userBean.completeTask(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            SpringTransactionIntegrationTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpringTransactionIntegrationTest.assertEquals((String)"My Task", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        results = (Integer)jdbcTemplate.queryForObject("select count(*) from MY_TABLE", Integer.class);
        SpringTransactionIntegrationTest.assertEquals((int)0, (int)results);
        jdbcTemplate.execute("drop table MY_TABLE if exists;");
    }

    @Deployment(resources={"org/camunda/bpm/engine/spring/test/transaction/SpringTransactionIntegrationTest.testErrorPropagationOnExceptionInTransaction.bpmn20.xml", "org/camunda/bpm/engine/spring/test/transaction/SpringTransactionIntegrationTest.throwExceptionProcess.bpmn20.xml"})
    public void testErrorPropagationOnExceptionInTransaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.waitForJobExecutorToProcessAllJobs(WAIT_TIME_MILLIS);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().activityId("servicetask").singleResult();
        Assert.assertThat((Object)incident.getIncidentMessage(), (Matcher)CoreMatchers.is((Object)"error"));
    }

    @Deployment
    public void testTransactionRollbackInServiceTask() throws Exception {
        this.runtimeService.startProcessInstanceByKey("txRollbackServiceTask");
        this.waitForJobExecutorToProcessAllJobs(WAIT_TIME_MILLIS);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        SpringTransactionIntegrationTest.assertNotNull((Object)job);
        SpringTransactionIntegrationTest.assertEquals((int)0, (int)job.getRetries());
        SpringTransactionIntegrationTest.assertEquals((String)"Transaction rolled back because it has been marked as rollback-only", (String)job.getExceptionMessage());
        String stacktrace = this.managementService.getJobExceptionStacktrace(job.getId());
        SpringTransactionIntegrationTest.assertNotNull((Object)stacktrace);
        SpringTransactionIntegrationTest.assertTrue((String)("unexpected stacktrace, was <" + stacktrace + ">"), (boolean)stacktrace.contains("Transaction rolled back because it has been marked as rollback-only"));
    }

    @Deployment
    public void testTransactionRollbackInServiceTaskWithCustomRetryCycle() throws Exception {
        this.runtimeService.startProcessInstanceByKey("txRollbackServiceTaskWithCustomRetryCycle");
        this.waitForJobExecutorToProcessAllJobs(WAIT_TIME_MILLIS);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        SpringTransactionIntegrationTest.assertNotNull((Object)job);
        SpringTransactionIntegrationTest.assertEquals((int)0, (int)job.getRetries());
        SpringTransactionIntegrationTest.assertEquals((String)"Transaction rolled back because it has been marked as rollback-only", (String)job.getExceptionMessage());
        String stacktrace = this.managementService.getJobExceptionStacktrace(job.getId());
        SpringTransactionIntegrationTest.assertNotNull((Object)stacktrace);
        SpringTransactionIntegrationTest.assertTrue((String)("unexpected stacktrace, was <" + stacktrace + ">"), (boolean)stacktrace.contains("Transaction rolled back because it has been marked as rollback-only"));
    }

    @Deployment
    public void testFailingTransactionListener() throws Exception {
        this.runtimeService.startProcessInstanceByKey("failingTransactionListener");
        this.waitForJobExecutorToProcessAllJobs(WAIT_TIME_MILLIS);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        SpringTransactionIntegrationTest.assertNotNull((Object)job);
        SpringTransactionIntegrationTest.assertEquals((int)0, (int)job.getRetries());
        SpringTransactionIntegrationTest.assertEquals((String)"exception in transaction listener", (String)job.getExceptionMessage());
        String stacktrace = this.managementService.getJobExceptionStacktrace(job.getId());
        SpringTransactionIntegrationTest.assertNotNull((Object)stacktrace);
        SpringTransactionIntegrationTest.assertTrue((String)("unexpected stacktrace, was <" + stacktrace + ">"), (boolean)stacktrace.contains("java.lang.RuntimeException: exception in transaction listener"));
    }
}

