/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.jpa;

import java.util.HashMap;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.engine.spring.test.jpa.LoanRequest;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/jpa/JPASpringTest-context.xml"})
public class JPASpringTest
extends SpringProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/spring/test/jpa/JPASpringTest.bpmn20.xml"})
    public void testJpaVariableHappyPath() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("customerName", "John Doe");
        variables.put("amount", 15000L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("LoanRequestProcess", variables);
        Object value = this.runtimeService.getVariable(processInstance.getId(), "loanRequest");
        JPASpringTest.assertNotNull((Object)value);
        JPASpringTest.assertTrue((boolean)(value instanceof LoanRequest));
        LoanRequest request = (LoanRequest)value;
        JPASpringTest.assertEquals((String)"John Doe", (String)request.getCustomerName());
        JPASpringTest.assertEquals((long)15000L, (long)request.getAmount());
        JPASpringTest.assertFalse((boolean)request.isApproved());
        variables = new HashMap();
        variables.put("approvedByManager", Boolean.TRUE);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        JPASpringTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId(), variables);
        JPASpringTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/spring/test/jpa/JPASpringTest.bpmn20.xml"})
    public void testJpaVariableDisapprovalPath() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("customerName", "Jane Doe");
        variables.put("amount", 50000);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("LoanRequestProcess", variables);
        Object value = this.runtimeService.getVariable(processInstance.getId(), "loanRequest");
        JPASpringTest.assertNotNull((Object)value);
        JPASpringTest.assertTrue((boolean)(value instanceof LoanRequest));
        LoanRequest request = (LoanRequest)value;
        JPASpringTest.assertEquals((String)"Jane Doe", (String)request.getCustomerName());
        JPASpringTest.assertEquals((long)50000L, (long)request.getAmount());
        JPASpringTest.assertFalse((boolean)request.isApproved());
        variables = new HashMap();
        variables.put("approvedByManager", Boolean.FALSE);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        JPASpringTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId(), variables);
        this.runtimeService.getVariable(processInstance.getId(), "loanRequest");
        request = (LoanRequest)value;
        JPASpringTest.assertFalse((boolean)request.isApproved());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        JPASpringTest.assertNotNull((Object)task);
        JPASpringTest.assertEquals((String)"Send rejection letter", (String)task.getName());
    }
}

