/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components.scope;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.components.ProcessInitiatingPojo;
import org.camunda.bpm.engine.spring.test.components.scope.StatefulObject;
import org.camunda.bpm.engine.task.Task;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.StringUtils;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/components/ScopingTests-context.xml"})
public class ScopingTest {
    @Autowired
    private ProcessInitiatingPojo processInitiatingPojo;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    @Autowired
    private ProcessEngine processEngine;
    private RepositoryService repositoryService;
    private TaskService taskService;
    public static long CUSTOMER_ID_PROC_VAR_VALUE = 343L;
    public static String customerIdProcVarName = "customerId";

    @Before
    public void before() throws Throwable {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.taskService = this.processEngine.getTaskService();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/spring/test/autodeployment/autodeploy.b.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/spring/test/components/waiter.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/spring/test/components/spring-component-waiter.bpmn20.xml").deploy();
    }

    @After
    public void after() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        this.processEngine.close();
        this.processEngine = null;
        this.repositoryService = null;
        this.taskService = null;
        this.processInitiatingPojo = null;
    }

    private StatefulObject run() throws Throwable {
        this.logger.info("----------------------------------------------");
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put(customerIdProcVarName, CUSTOMER_ID_PROC_VAR_VALUE);
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByKey("component-waiter", vars);
        StatefulObject scopedObject = (StatefulObject)this.processEngine.getRuntimeService().getVariable(processInstance.getId(), "scopedTarget.c1");
        Assert.assertNotNull((String)"the scopedObject can't be null", (Object)scopedObject);
        Assert.assertTrue((String)"the 'name' property can't be null.", (boolean)StringUtils.hasText((String)scopedObject.getName()));
        Assert.assertEquals((long)scopedObject.getVisitedCount(), (long)2L);
        String procId = processInstance.getProcessInstanceId();
        List tasks = this.taskService.createTaskQuery().executionId(procId).list();
        Assert.assertEquals((String)"there should be 1 (one) task enqueued at this point.", (long)tasks.size(), (long)1L);
        Task t = (Task)tasks.iterator().next();
        this.taskService.claim(t.getId(), "me");
        this.logger.info("sleeping for 10 seconds while a user performs his task. The first transaction has committed. A new one will start in 10 seconds");
        Thread.sleep(5000L);
        this.taskService.complete(t.getId());
        scopedObject = (StatefulObject)this.processEngine.getRuntimeService().getVariable(processInstance.getId(), "scopedTarget.c1");
        Assert.assertEquals((long)scopedObject.getVisitedCount(), (long)3L);
        Assert.assertEquals((String)"the customerId injected should be what was given as a processVariable parameter.", (long)CUSTOMER_ID_PROC_VAR_VALUE, (long)scopedObject.getCustomerId());
        return scopedObject;
    }

    @Test
    public void testUsingAnInjectedScopedProxy() throws Throwable {
        this.logger.info("Running 'component-waiter' process instance with scoped beans.");
        StatefulObject one = this.run();
        StatefulObject two = this.run();
        Assert.assertNotSame((Object)one.getName(), (Object)two.getName());
        Assert.assertEquals((long)one.getVisitedCount(), (long)two.getVisitedCount());
    }

    @Test
    public void testStartingAProcessWithScopedBeans() throws Throwable {
        this.processInitiatingPojo.startScopedProcess(3243L);
    }
}

