/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components.scope;

import java.io.Serializable;
import java.util.logging.Logger;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

public class StatefulObject
implements Serializable,
InitializingBean {
    private transient Logger logger = Logger.getLogger(this.getClass().getName());
    public static final long serialVersionUID = 1L;
    private String name;
    private int visitedCount = 0;
    private long customerId;
    @Value(value="#{processInstance}")
    transient ProcessInstance processInstance;
    @Value(value="#{executionId}")
    String executionId;

    public long getCustomerId() {
        return this.customerId;
    }

    @Value(value="#{processVariables['customerId']}")
    public void setCustomerId(long customerId) {
        this.customerId = customerId;
        this.logger.info("setting this " + StatefulObject.class.getName() + " instances 'customerId' to " + this.customerId + ". The current executionId is " + this.executionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatefulObject that = (StatefulObject)o;
        if (this.visitedCount != that.visitedCount) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.visitedCount;
        return result;
    }

    public String toString() {
        return "StatefulObject{name='" + this.name + '\'' + ", visitedCount=" + this.visitedCount + '}';
    }

    public void increment() {
        ++this.visitedCount;
    }

    public int getVisitedCount() {
        return this.visitedCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processInstance, (String)"the processInstance should be equal to the currently active processInstance!");
        this.logger.info("the 'processInstance' property is non-null: PI ID# " + this.processInstance.getId());
    }
}

