/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.junit4;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/junit4/springTypicalUsageTest-context.xml"})
public class SpringJunit4Test {
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    @Rule
    public ProcessEngineRule activitiSpringRule;

    @After
    public void closeProcessEngine() {
        this.processEngine.close();
        this.processEngine = null;
        this.runtimeService = null;
        this.taskService = null;
        this.activitiSpringRule = null;
    }

    @Test
    @Deployment
    public void simpleProcessTest() {
        this.runtimeService.startProcessInstanceByKey("simpleProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }
}

