/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.scripttask;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/scripttask/ScriptTaskTest-applicationContext.xml"})
public class ScriptTaskTest {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    private static final String JAVASCRIPT = "javascript";
    private static final String PYTHON = "python";
    private static final String GROOVY = "groovy";
    private static final String JUEL = "juel";
    private static final String TEST_BEAN_NAME = "name property of testbean";
    private List<String> deploymentIds = new ArrayList<String>();

    @After
    public void after() {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    @Test
    public void testJavascriptSpringBeanVisibility() {
        this.testSpringBeanVisibility(JAVASCRIPT, "execution.setVariable('foo', testbean.name);");
    }

    @Test
    public void testGroovySpringBeanVisibility() {
        this.testSpringBeanVisibility(GROOVY, "execution.setVariable('foo', testbean.name)\n");
    }

    @Test
    public void testPythonSpringBeanVisibility() {
        this.testSpringBeanVisibility(PYTHON, "execution.setVariable('foo', testbean.name)\n");
    }

    @Test
    public void testJuelSpringBeanVisibility() {
        this.testSpringBeanVisibility(JUEL, "${execution.setVariable('foo', testbean.name)}");
    }

    protected void deployProcess(BpmnModelInstance process) {
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    protected void deployProcess(String scriptFormat, String scriptText) {
        BpmnModelInstance process = this.createProcess(scriptFormat, scriptText);
        this.deployProcess(process);
    }

    protected BpmnModelInstance createProcess(String scriptFormat, String scriptText) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(scriptFormat)).scriptText(scriptText)).userTask().endEvent().done();
    }

    protected void testSpringBeanVisibility(String scriptFormat, String scriptText) {
        this.deployProcess(scriptFormat, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        Assert.assertEquals((Object)TEST_BEAN_NAME, (Object)variableValue);
    }
}

