/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.configuration;

import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.engine.spring.test.configuration.Counter;
import org.camunda.bpm.engine.spring.test.configuration.InMemProcessEngineConfiguration;
import org.camunda.bpm.engine.test.Deployment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={InMemProcessEngineConfiguration.class, SpringProcessEngineServicesConfiguration.class})
public class JavaBasedProcessEngineConfigTest
extends SpringProcessEngineTestCase {
    @Autowired
    private Counter couter;
    @Autowired
    protected RuntimeService runtimeService;

    @Deployment
    public void testDelegateExpression() {
        this.runtimeService.startProcessInstanceByKey("SpringProcess");
        Assert.assertThat((Object)this.couter.getCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment
    public void testExpression() {
        this.runtimeService.startProcessInstanceByKey("SpringProcess");
        Assert.assertThat((Object)this.couter.getCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment
    public void testDelegateExpressionWithProcessServices() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("SpringProcess").getId();
        Assert.assertThat((Object)this.couter.getCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)this.runtimeService.getVariable(processInstanceId, "count")), (Matcher)CoreMatchers.is((Object)1));
    }
}

