/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.scripttask;

import org.camunda.bpm.engine.spring.test.scripttask.AbstractScriptTaskTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/scripttask/ScriptTaskTest-applicationContext.xml"})
public class ScriptTaskTest
extends AbstractScriptTaskTest {
    private static final String JAVASCRIPT = "javascript";
    private static final String PYTHON = "python";
    private static final String GROOVY = "groovy";
    private static final String JUEL = "juel";

    @Test
    public void shouldFindPublicSpringBeanMethodWithJavascriptGraalJs() {
        this.testSpringBeanVisibility(JAVASCRIPT, "execution.setVariable('foo', testbean.getName());");
    }

    @Test
    public void shouldFindPublicSpringBeanMethodWithGroovy() {
        this.testSpringBeanVisibility(GROOVY, "execution.setVariable('foo', testbean.getName())\n");
    }

    @Test
    public void shouldFindPublicSpringBeanMethodWithPython() {
        this.testSpringBeanVisibility(PYTHON, "execution.setVariable('foo', testbean.getName())\n");
    }

    @Test
    public void shouldFindPublicSpringBeanMethodWithJuel() {
        this.testSpringBeanVisibility(JUEL, "${execution.setVariable('foo', testbean.getName())}");
    }

    @Test
    public void shouldNotFindPrivateSpringBeanAttributeWithJavascriptGraalJs() {
        this.testSpringBeanVisibility(JAVASCRIPT, "execution.setVariable('foo', testbean.name);", false);
    }

    @Test
    public void shouldFindPrivateSpringBeanAttributeWithWithGroovy() {
        this.testSpringBeanVisibility(GROOVY, "execution.setVariable('foo', testbean.name)\n");
    }

    @Test
    public void shouldFindPrivateSpringBeanAttributeWithPython() {
        this.testSpringBeanVisibility(PYTHON, "execution.setVariable('foo', testbean.name)\n");
    }

    @Test
    public void shouldFindPrivateSpringBeanAttributeWithJuel() {
        this.testSpringBeanVisibility(JUEL, "${execution.setVariable('foo', testbean.name)}");
    }
}

