/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.servicetask;

import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/servicetask/servicetaskSpringTest-context.xml"})
public class ServiceTaskSpringDelegationTest
extends SpringProcessEngineTestCase {
    @Deployment
    public void testDelegateExpression() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("delegateExpressionToSpringBean");
        ServiceTaskSpringDelegationTest.assertEquals((Object)"Activiti BPMN 2.0 process engine", (Object)this.runtimeService.getVariable(procInst.getId(), "myVar"));
        ServiceTaskSpringDelegationTest.assertEquals((Object)"fieldInjectionWorking", (Object)this.runtimeService.getVariable(procInst.getId(), "fieldInjection"));
    }

    @Deployment
    public void testDelegateClass() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("delegateClassToSpringBean");
        ServiceTaskSpringDelegationTest.assertEquals((Object)"Activiti BPMN 2.0 process engine", (Object)this.runtimeService.getVariable(procInst.getId(), "myVar"));
        ServiceTaskSpringDelegationTest.assertEquals((Object)"fieldInjectionWorking", (Object)this.runtimeService.getVariable(procInst.getId(), "fieldInjection"));
    }

    @Deployment
    public void testDelegateClassNotABean() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("delegateClassToSpringBean");
        ServiceTaskSpringDelegationTest.assertEquals((Object)"DelegateClassNotABean was called", (Object)this.runtimeService.getVariable(procInst.getId(), "message"));
        ServiceTaskSpringDelegationTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(procInst.getId(), "injectedFieldIsNull")));
    }

    @Deployment
    public void testMethodExpressionOnSpringBean() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("methodExpressionOnSpringBean");
        ServiceTaskSpringDelegationTest.assertEquals((Object)"ACTIVITI BPMN 2.0 PROCESS ENGINE", (Object)this.runtimeService.getVariable(procInst.getId(), "myVar"));
    }

    @Deployment
    public void testExecutionAndTaskListenerDelegationExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionAndTaskListenerDelegation");
        ServiceTaskSpringDelegationTest.assertEquals((Object)"working", (Object)this.runtimeService.getVariable(processInstance.getId(), "executionListenerVar"));
        ServiceTaskSpringDelegationTest.assertEquals((Object)"working", (Object)this.runtimeService.getVariable(processInstance.getId(), "taskListenerVar"));
        ServiceTaskSpringDelegationTest.assertEquals((Object)"executionListenerInjection", (Object)this.runtimeService.getVariable(processInstance.getId(), "executionListenerField"));
        ServiceTaskSpringDelegationTest.assertEquals((Object)"taskListenerInjection", (Object)this.runtimeService.getVariable(processInstance.getId(), "taskListenerField"));
    }
}

