/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test;

import java.util.ServiceLoader;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.spring.test.SpringTestHelper;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public abstract class SpringProcessEngineTestCase
extends AbstractProcessEngineTestCase
implements ApplicationContextAware {
    protected TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());
    @Autowired
    protected ConfigurableApplicationContext applicationContext;

    public SpringProcessEngineTestCase() {
        SpringTestHelper testHelper = this.lookupTestHelper();
        testHelper.beforeTestClass(this.testContextManager);
    }

    protected SpringTestHelper lookupTestHelper() {
        ServiceLoader<SpringTestHelper> serviceLoader = ServiceLoader.load(SpringTestHelper.class);
        return serviceLoader.iterator().next();
    }

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        try {
            super.runBare();
        }
        finally {
            this.testContextManager.afterTestClass();
            this.applicationContext.close();
            this.applicationContext = null;
            this.processEngine = null;
            this.testContextManager = null;
            CachedIntrospectionResults.clearClassLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
    }

    protected void initializeProcessEngine() {
        ContextConfiguration contextConfiguration = ((Object)((Object)this)).getClass().getAnnotation(ContextConfiguration.class);
        this.processEngine = (ProcessEngine)this.applicationContext.getBean(ProcessEngine.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

