/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components;

import java.util.logging.Logger;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.annotations.BusinessKey;
import org.camunda.bpm.engine.spring.annotations.ProcessVariable;
import org.camunda.bpm.engine.spring.annotations.StartProcess;
import org.camunda.bpm.engine.spring.test.components.ScopedCustomer;

public class ProcessInitiatingPojo {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private int methodState = 0;
    private ScopedCustomer customer;

    public void reset() {
        this.methodState = 0;
    }

    public void setCustomer(ScopedCustomer customer) {
        this.customer = customer;
    }

    public void logScopedCustomer(ProcessInstance processInstance) {
        System.out.println("ProcessInstance ID:" + processInstance.getId() + "; Name: " + this.customer.getName());
    }

    @StartProcess(processKey="b")
    public void startProcess(@ProcessVariable(value="customerId") long customerId) {
        this.log.info("starting 'b' with customerId # " + customerId);
        ++this.methodState;
        this.log.info("up'd the method state");
    }

    public int getMethodState() {
        return this.methodState;
    }

    @StartProcess(processKey="waiter", returnProcessInstanceId=true)
    public String startProcessA(@ProcessVariable(value="customerId") long cId) {
        return null;
    }

    @StartProcess(processKey="waiter")
    public ProcessInstance enrollCustomer(@BusinessKey String key, @ProcessVariable(value="customerId") long customerId) {
        return null;
    }

    @StartProcess(processKey="component-waiter")
    public void startScopedProcess(@ProcessVariable(value="customerId") long customerId) {
        this.log.info(" start scoped 'component-waiter' process.");
    }
}

