/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction.crdb;

import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/transaction/CrdbTransactionIntegrationTest-applicationContext.xml"})
public class CrdbTxRetryOnCommitTest {
    @Rule
    @Autowired
    public ProcessEngineRule rule;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Autowired
    public ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String dbType;

    @Before
    public void setUp() {
        this.dbType = this.processEngineConfiguration.getDatabaseType();
        this.processEngineConfiguration.setDatabaseType("cockroachdb");
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setDatabaseType(this.dbType);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/spring/test/transaction/CrdbTransactionIntegrationTest.crdbFailureProcess.bpmn20.xml"})
    public void shouldReportCrdbException() {
        this.thrown.expect(CrdbTransactionRetryException.class);
        this.processEngineConfiguration.getRuntimeService().startProcessInstanceByKey("crdbFailureProcess");
    }
}

