/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.application;

import org.camunda.bpm.application.PostDeploy;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.spring.application.SpringProcessApplication;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class PostDeployWithNestedContext
extends SpringProcessApplication {
    boolean deployCalled = false;
    boolean triggered = false;
    boolean deployOnChildRefresh;

    public void setApplicationContext(ApplicationContext mainContext) throws BeansException {
        super.setApplicationContext(mainContext);
        AnnotationConfigApplicationContext nestedContext = new AnnotationConfigApplicationContext();
        nestedContext.setParent(mainContext);
        this.deployCalled = false;
        nestedContext.refresh();
        this.deployOnChildRefresh = this.deployCalled;
        ((AbstractApplicationContext)mainContext).addApplicationListener((ApplicationListener)new ApplicationListener<MyEvent>(){

            public void onApplicationEvent(MyEvent event) {
                PostDeployWithNestedContext.this.triggered = true;
            }
        });
    }

    @PostDeploy
    public void registerProcessApplication(ProcessEngine processEngine) {
        this.deployCalled = true;
        this.applicationContext.publishEvent((ApplicationEvent)new MyEvent((Object)this));
    }

    public boolean isDeployOnChildRefresh() {
        return this.deployOnChildRefresh;
    }

    public boolean isLateEventTriggered() {
        return this.triggered;
    }

    public class MyEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;

        public MyEvent(Object source) {
            super(source);
        }
    }
}

