/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring;

import java.sql.SQLException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionInterceptor
extends CommandInterceptor {
    protected PlatformTransactionManager transactionManager;
    protected int transactionPropagation;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Deprecated
    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager, int transactionPropagation) {
        this(transactionManager, transactionPropagation, null);
    }

    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager, int transactionPropagation, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.transactionManager = transactionManager;
        this.transactionPropagation = transactionPropagation;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public <T> T execute(Command<T> command) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(this.transactionPropagation);
        try {
            return (T)transactionTemplate.execute(status -> this.next.execute(command));
        }
        catch (TransactionSystemException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException && this.processEngineConfiguration != null && DbSqlSession.isCrdbConcurrencyConflictOnCommit((Exception)((SQLException)cause), (ProcessEngineConfigurationImpl)this.processEngineConfiguration)) {
                throw ProcessEngineLogger.PERSISTENCE_LOGGER.crdbTransactionRetryExceptionOnCommit(cause);
            }
            throw ex;
        }
    }
}

